/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.validation.specs;

import com.galenframework.page.PageElement;
import com.galenframework.page.Rect;
import com.galenframework.specs.Location;
import com.galenframework.specs.Spec;
import com.galenframework.specs.SpecComplex;
import com.galenframework.validation.PageValidation;
import com.galenframework.validation.SpecValidation;
import com.galenframework.validation.ValidationErrorException;
import com.galenframework.validation.ValidationObject;
import com.galenframework.validation.ValidationResult;
import com.galenframework.validation.ValidationUtils;
import java.util.LinkedList;
import java.util.List;

public abstract class SpecValidationGeneral<T extends SpecComplex>
extends SpecValidation<T>
implements ValidationUtils.OffsetProvider {
    @Override
    public ValidationResult check(PageValidation pageValidation, String objectName, T spec) throws ValidationErrorException {
        PageElement mainObject = pageValidation.findPageElement(objectName);
        this.checkAvailability(mainObject, objectName);
        PageElement secondObject = pageValidation.findPageElement(((SpecComplex)spec).getObject());
        this.checkAvailability(secondObject, ((SpecComplex)spec).getObject());
        Rect mainArea = mainObject.getArea();
        Rect secondArea = secondObject.getArea();
        LinkedList<String> messages = new LinkedList<String>();
        for (Location location : ((SpecComplex)spec).getLocations()) {
            String message = ValidationUtils.verifyLocation(mainArea, secondArea, location, pageValidation, spec, this);
            if (message == null) continue;
            messages.add(message);
        }
        LinkedList<ValidationObject> validationObjects = new LinkedList<ValidationObject>();
        validationObjects.add(new ValidationObject(mainArea, objectName));
        validationObjects.add(new ValidationObject(secondArea, ((SpecComplex)spec).getObject()));
        if (messages.size() > 0) {
            throw new ValidationErrorException().withMessage(ValidationUtils.joinErrorMessagesForObject(messages, objectName)).withValidationObjects(validationObjects);
        }
        return new ValidationResult((Spec)spec, (List<ValidationObject>)validationObjects);
    }
}

