/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.validation.specs;

import com.galenframework.page.Point;
import com.galenframework.page.Rect;
import com.galenframework.specs.Range;
import com.galenframework.specs.Side;
import com.galenframework.specs.SpecInside;
import com.galenframework.validation.MetaBasedValidation;
import com.galenframework.validation.PageValidation;
import com.galenframework.validation.SimpleValidationResult;
import com.galenframework.validation.ValidationErrorException;
import com.galenframework.validation.ValidationObject;
import com.galenframework.validation.specs.SpecValidationComplex;
import java.util.List;

public class SpecValidationInside
extends SpecValidationComplex<SpecInside> {
    @Override
    protected SimpleValidationResult validateSide(String objectName, SpecInside spec, Range range, Side side, Rect mainArea, Rect secondArea, PageValidation pageValidation) {
        return MetaBasedValidation.forObjectsWithRange(objectName, spec.getObject(), range).withBothEdges(side).withInvertedCalculation(side == Side.RIGHT || side == Side.BOTTOM).validate(mainArea, secondArea, pageValidation, side.toString());
    }

    @Override
    protected void doCustomValidations(String objectName, Rect mainArea, Rect secondArea, SpecInside spec, List<ValidationObject> objects) throws ValidationErrorException {
        this.checkIfCompletelyInside(objectName, spec, mainArea, secondArea, objects);
    }

    private void checkIfCompletelyInside(String objectName, SpecInside spec, Rect mainArea, Rect secondArea, List<ValidationObject> objects) throws ValidationErrorException {
        if (!spec.getPartly()) {
            Point[] points = mainArea.getPoints();
            int maxOffset = 0;
            for (Point point : points) {
                int offset = secondArea.calculatePointOffsetDistance(point);
                if (maxOffset >= offset) continue;
                maxOffset = offset;
            }
            if (maxOffset > 2) {
                throw new ValidationErrorException().withValidationObjects(objects).withMessage(String.format("\"%s\" is not completely inside. The offset is %dpx.", objectName, maxOffset));
            }
        }
    }
}

