/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.validation.specs;

import com.galenframework.page.PageElement;
import com.galenframework.reports.model.LayoutMeta;
import com.galenframework.specs.Range;
import com.galenframework.specs.RangeValue;
import com.galenframework.specs.Spec;
import com.galenframework.specs.SpecRange;
import com.galenframework.validation.PageValidation;
import com.galenframework.validation.SpecValidation;
import com.galenframework.validation.ValidationErrorException;
import com.galenframework.validation.ValidationObject;
import com.galenframework.validation.ValidationResult;
import com.galenframework.validation.ValidationUtils;
import java.util.Arrays;
import java.util.List;

public abstract class SpecValidationSize<T extends SpecRange>
extends SpecValidation<T> {
    @Override
    public ValidationResult check(PageValidation pageValidation, String objectName, T spec) throws ValidationErrorException {
        PageElement mainObject = pageValidation.findPageElement(objectName);
        this.checkAvailability(mainObject, objectName);
        double realValue = this.getSizeValue(mainObject);
        double convertedValue = pageValidation.convertValue(((SpecRange)spec).getRange(), realValue);
        List<ValidationObject> validationObjects = Arrays.asList(new ValidationObject(mainObject.getArea(), objectName));
        List<LayoutMeta> meta = Arrays.asList(this.createMeta(objectName, this.formatExpectedValue(((SpecRange)spec).getRange(), pageValidation), this.formatRealValue(realValue, convertedValue, ((SpecRange)spec).getRange())));
        if (!((SpecRange)spec).getRange().holds(convertedValue)) {
            throw new ValidationErrorException().withValidationObjects(validationObjects).withMessage(String.format("\"%s\" %s is %s", objectName, this.getUnitName(), this.getReadableRangeAndValue(((SpecRange)spec).getRange(), realValue, convertedValue, pageValidation))).withMeta(meta);
        }
        return new ValidationResult((Spec)spec, validationObjects).withMeta(meta);
    }

    private String formatRealValue(double realValue, double convertedValue, Range range) {
        if (range.isPercentage()) {
            return String.format("%s%% [%dpx]", new RangeValue(convertedValue, range.findPrecision()).toString(), (int)realValue);
        }
        return String.format("%spx", new RangeValue(realValue, range.findPrecision()).toString());
    }

    private String formatExpectedValue(Range range, PageValidation pageValidation) {
        if (range.isPercentage()) {
            int objectValue = pageValidation.getObjectValue(range.getPercentageOfValue());
            return String.format("%s %s", range.prettyString("%"), ValidationUtils.rangeCalculatedFromPercentage(range, objectValue));
        }
        return range.prettyString();
    }

    protected abstract LayoutMeta createMeta(String var1, String var2, String var3);

    protected abstract String getUnitName();

    protected abstract int getSizeValue(PageElement var1);
}

