/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.rainbow4j.colorscheme;

import com.galenframework.rainbow4j.colorscheme.ColorClassifier;
import java.awt.Color;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class SimpleColorClassifier
implements ColorClassifier {
    private final int red;
    private final int blue;
    private final int green;
    private String name;

    public SimpleColorClassifier(String name, Color color) {
        this.name = name;
        this.red = color.getRed();
        this.blue = color.getBlue();
        this.green = color.getGreen();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean holdsColor(int r, int g, int b, int maxColorSquareDistance) {
        int distance = (r - this.red) * (r - this.red) + (g - this.green) * (g - this.green) + (b - this.blue) * (b - this.blue);
        return distance < maxColorSquareDistance;
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.red).append(this.blue).append(this.green).append((Object)this.name).toHashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SimpleColorClassifier)) {
            return false;
        }
        SimpleColorClassifier rhs = (SimpleColorClassifier)obj;
        return new EqualsBuilder().append(rhs.red, this.red).append(rhs.blue, this.blue).append(rhs.green, this.green).append((Object)rhs.name, (Object)this.name).isEquals();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("red", this.red).append("blue", this.blue).append("green", this.green).append("name", (Object)this.name).toString();
    }
}

