/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.rainbow4j.filters;

import com.galenframework.rainbow4j.BufferUtils;
import com.galenframework.rainbow4j.filters.ImageFilter;
import java.awt.Rectangle;
import java.nio.ByteBuffer;

public class BlurFilter
implements ImageFilter {
    private int radius;

    public BlurFilter(int radius) {
        this.radius = radius;
    }

    public int getRadius() {
        return this.radius;
    }

    public void setRadius(int radius) {
        this.radius = radius;
    }

    @Override
    public void apply(ByteBuffer bytes, int width, int height, Rectangle area) {
        if (area.width + area.x > width || area.height + area.y > height) {
            throw new RuntimeException("Specified area is outside of image");
        }
        if (this.radius > 0) {
            ByteBuffer copyBytes = BufferUtils.clone(bytes);
            for (int yc = area.y; yc < area.y + area.height; ++yc) {
                for (int xc = area.x; xc < area.x + area.width; ++xc) {
                    int startY = Math.max(yc - this.radius, area.y);
                    int startX = Math.max(xc - this.radius, area.x);
                    int endY = Math.min(yc + this.radius, area.height + area.y - 1);
                    int endX = Math.min(xc + this.radius, area.width + area.x - 1);
                    int ar = 0;
                    int ag = 0;
                    int ab = 0;
                    double sumWeight = 0.0;
                    for (int y = startY; y <= endY; ++y) {
                        for (int x = startX; x <= endX; ++x) {
                            int k = y * width * 4 + x * 4;
                            int r = copyBytes.get(k) & 0xFF;
                            int g = copyBytes.get(k + 1) & 0xFF;
                            int b = copyBytes.get(k + 2) & 0xFF;
                            double distance = Math.max(Math.abs(x - xc), Math.abs(y - yc));
                            double dWeight = 1.0 - distance / (double)(this.radius + 1);
                            sumWeight += dWeight;
                            ar = (int)((double)ar + (double)r * dWeight);
                            ag = (int)((double)ag + (double)g * dWeight);
                            ab = (int)((double)ab + (double)b * dWeight);
                        }
                    }
                    int k = yc * width * 4 + xc * 4;
                    bytes.put(k, (byte)((double)ar / sumWeight));
                    bytes.put(k + 1, (byte)((double)ag / sumWeight));
                    bytes.put(k + 2, (byte)((double)ab / sumWeight));
                }
            }
        }
    }
}

