/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.rainbow4j.filters;

import com.galenframework.rainbow4j.filters.ImageFilter;
import java.awt.Rectangle;
import java.nio.ByteBuffer;

public class SaturationFilter
implements ImageFilter {
    private int level;

    public SaturationFilter(int level) {
        this.level = level;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    @Override
    public void apply(ByteBuffer bytes, int width, int height, Rectangle area) {
        if (this.level > 100) {
            this.level = 100;
        } else if (this.level < 0) {
            this.level = 0;
        }
        double t = (double)this.level / 100.0;
        for (int y = area.y; y < area.y + area.height; ++y) {
            for (int x = area.x; x < area.x + area.width; ++x) {
                int k = y * width * 4 + x * 4;
                double red = bytes.get(k & 0xFF);
                double green = bytes.get(k + 1 & 0xFF);
                double blue = bytes.get(k + 2 & 0xFF);
                double gray = green * 0.59 + red * 0.3 + blue * 0.11;
                bytes.put(k, (byte)this.colorRange(gray * (1.0 - t) + red * t));
                bytes.put(k + 1, (byte)this.colorRange(gray * (1.0 - t) + green * t));
                bytes.put(k + 2, (byte)this.colorRange(gray * (1.0 - t) + blue * t));
            }
        }
    }

    private int colorRange(double color) {
        int c = (int)color;
        if (c > 255) {
            return 255;
        }
        if (c < 0) {
            return 0;
        }
        return c;
    }
}

