/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.rainbow4j.filters;

import com.galenframework.rainbow4j.BufferUtils;
import com.galenframework.rainbow4j.filters.ImageFilter;
import java.awt.Rectangle;
import java.nio.ByteBuffer;

public class DenoiseFilter
implements ImageFilter {
    private int radius;

    public DenoiseFilter(int radius) {
        this.radius = radius;
    }

    @Override
    public void apply(ByteBuffer bytes, int width, int height, Rectangle area) {
        this.radius = Math.min(this.radius, Math.min(width / 2, height / 2));
        int normalThreshold = 100;
        if (this.radius > 0) {
            ByteBuffer copyBytes = BufferUtils.clone(bytes);
            for (int yc = area.y; yc < area.y + area.height; ++yc) {
                for (int xc = area.x; xc < area.x + area.width; ++xc) {
                    int startY = yc - this.radius;
                    int startX = xc - this.radius;
                    int endY = yc + this.radius;
                    int endX = xc + this.radius;
                    int ar = 0;
                    int ag = 0;
                    int ab = 0;
                    double sumWeight = 0.0;
                    for (int y = startY; y <= endY; ++y) {
                        for (int x = startX; x <= endX; ++x) {
                            int b;
                            int g;
                            int r;
                            if (x >= area.x && x < area.x + area.width && y >= area.y && y < area.y + area.height) {
                                int k = y * width * 4 + x * 4;
                                r = copyBytes.get(k) & 0xFF;
                                g = copyBytes.get(k + 1) & 0xFF;
                                b = copyBytes.get(k + 2) & 0xFF;
                            } else {
                                r = 0;
                                g = 0;
                                b = 0;
                            }
                            double distance = Math.max(Math.abs(x - xc), Math.abs(y - yc));
                            double dWeight = 1.0 - distance / (double)(this.radius + 1);
                            sumWeight += dWeight;
                            ar = (int)((double)ar + (double)r * dWeight);
                            ag = (int)((double)ag + (double)g * dWeight);
                            ab = (int)((double)ab + (double)b * dWeight);
                        }
                    }
                    int k = yc * width * 4 + xc * 4;
                    if (!(sumWeight > 0.0)) continue;
                    int blurredRed = (int)((double)ar / sumWeight);
                    int blurredGreen = (int)((double)ag / sumWeight);
                    int blurredBlue = (int)((double)ab / sumWeight);
                    if (blurredRed >= normalThreshold || blurredGreen >= normalThreshold || blurredBlue >= normalThreshold) continue;
                    bytes.put(k, (byte)0);
                    bytes.put(k + 1, (byte)0);
                    bytes.put(k + 2, (byte)0);
                }
            }
        }
    }

    public int getRadius() {
        return this.radius;
    }

    public void setRadius(int radius) {
        this.radius = radius;
    }
}

