/*
 * Decompiled with CFR 0.152.
 */
package com.geotab.api;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.geotab.http.request.AuthenticatedRequest;
import com.geotab.http.request.BaseRequest;
import com.geotab.http.request.MultiCallRequest;
import com.geotab.http.request.param.AuthenticatedParameters;
import com.geotab.http.request.param.EntityParameters;
import com.geotab.http.request.param.GetFeedParameters;
import com.geotab.http.request.param.Parameters;
import com.geotab.http.request.param.SearchParameters;
import com.geotab.http.response.BaseResponse;
import com.geotab.model.FeedResult;
import com.geotab.model.Id;
import com.geotab.model.entity.Entity;
import com.geotab.model.login.LoginResult;
import com.geotab.model.search.Search;
import java.io.Closeable;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nullable;

public interface Api
extends Closeable {
    public static final String Add = "Add";
    public static final String Get = "Get";
    public static final String GetCountOf = "GetCountOf";
    public static final String GetFeed = "GetFeed";
    public static final String Remove = "Remove";
    public static final String Set = "Set";

    public LoginResult authenticate();

    public boolean isAuthenticated();

    public <O extends BaseResponse<T>, T> Optional<T> call(AuthenticatedRequest<?> var1, Class<O> var2);

    public <T> Optional<T> callResult(AuthenticatedRequest<?> var1, Class<T> var2);

    public <T> Optional<List<T>> callResultList(AuthenticatedRequest<?> var1, Class<T> var2);

    public <P extends AuthenticatedParameters, R> Optional<R> callMethod(MethodDescriptor<P, R> var1, P var2);

    public Optional<Id> callAdd(AuthenticatedRequest<?> var1);

    default public Optional<Id> callAdd(AuthenticatedParameters in) {
        return this.callAdd((AuthenticatedRequest<?>)((AuthenticatedRequest.AuthenticatedRequestBuilder)((AuthenticatedRequest.AuthenticatedRequestBuilder)AuthenticatedRequest.authRequestBuilder().method(Add)).params(in)).build());
    }

    default public <E extends Entity> Optional<Id> callAdd(EntityDescriptor<E, ?> type, E entity) {
        return this.callAdd(((EntityParameters.EntityParametersBuilder)((EntityParameters.EntityParametersBuilder)EntityParameters.entityParamsBuilder().typeName(type.name())).entity(entity)).build());
    }

    public <T extends Entity> Optional<List<T>> callGet(AuthenticatedRequest<?> var1, Class<T> var2);

    default public <T extends Entity> Optional<List<T>> callGet(SearchParameters<?> in, Class<T> outT) {
        return this.callGet((AuthenticatedRequest<?>)((AuthenticatedRequest.AuthenticatedRequestBuilder)((AuthenticatedRequest.AuthenticatedRequestBuilder)AuthenticatedRequest.authRequestBuilder().method(Get)).params(in)).build(), outT);
    }

    default public <E extends Entity, S extends Search> Optional<List<E>> callGet(EntityDescriptor<E, S> type, @Nullable S search) {
        return this.callGet(type, search, null);
    }

    default public <E extends Entity, S extends Search> Optional<List<E>> callGet(EntityDescriptor<E, S> type, @Nullable S search, @Nullable Integer resultLimit) {
        return this.callGet((SearchParameters<?>)((SearchParameters.SearchParametersBuilder)((Parameters.ParametersBuilder)((SearchParameters.SearchParametersBuilder)SearchParameters.searchParamsBuilder().typeName(type.name())).search(search)).resultsLimit(resultLimit)).build(), (Class)type.type);
    }

    default public <E extends Entity> Optional<List<E>> callGetAll(EntityDescriptor<E, ?> type) {
        return this.callGet(type, null);
    }

    default public <E extends Entity> Optional<E> callGetById(EntityDescriptor<E, ?> type, String id) {
        return this.callGet((SearchParameters<?>)((SearchParameters.SearchParametersBuilder)((SearchParameters.SearchParametersBuilder)SearchParameters.searchParamsBuilder().typeName(type.name())).search(new Search(id))).build(), (Class)type.type).map(o -> {
            if (o.isEmpty()) {
                return null;
            }
            if (o.size() > 1) {
                throw new IllegalStateException("Query by ID returned more than one result");
            }
            return (Entity)o.get(0);
        });
    }

    public Optional<Integer> callGetCountOf(AuthenticatedRequest<?> var1);

    default public Optional<Integer> callGetCountOf(SearchParameters<?> in) {
        return this.callGetCountOf((AuthenticatedRequest<?>)((AuthenticatedRequest.AuthenticatedRequestBuilder)((AuthenticatedRequest.AuthenticatedRequestBuilder)AuthenticatedRequest.authRequestBuilder().method(GetCountOf)).params(in)).build());
    }

    default public <E extends Entity, S extends Search> Optional<Integer> callGetCountOf(EntityDescriptor<E, S> type, S search) {
        return this.callGetCountOf((SearchParameters<?>)((SearchParameters.SearchParametersBuilder)((SearchParameters.SearchParametersBuilder)SearchParameters.searchParamsBuilder().typeName(type.name())).search(search)).build());
    }

    public <T extends Entity> Optional<FeedResult<T>> callGetFeed(AuthenticatedRequest<?> var1, Class<T> var2);

    default public <T extends Entity> Optional<FeedResult<T>> callGetFeed(GetFeedParameters<?> in, Class<T> outT) {
        return this.callGetFeed((AuthenticatedRequest<?>)((AuthenticatedRequest.AuthenticatedRequestBuilder)((AuthenticatedRequest.AuthenticatedRequestBuilder)AuthenticatedRequest.authRequestBuilder().method(GetFeed)).params(in)).build(), outT);
    }

    default public <E extends Entity, S extends Search> Optional<List<E>> callGetFeed(EntityDescriptor<E, S> type, S search, @Nullable String fromVersion, @Nullable Integer resultLimit) {
        return this.callGet(((GetFeedParameters.GetFeedParametersBuilder)((Parameters.ParametersBuilder)((GetFeedParameters.GetFeedParametersBuilder)((GetFeedParameters.GetFeedParametersBuilder)GetFeedParameters.getFeedParamsBuilder().typeName(type.name())).search(search)).fromVersion(fromVersion)).resultsLimit(resultLimit)).build(), type.type);
    }

    public void callSet(AuthenticatedRequest<?> var1);

    default public void callSet(AuthenticatedParameters in) {
        this.callSet((AuthenticatedRequest<?>)((AuthenticatedRequest.AuthenticatedRequestBuilder)((AuthenticatedRequest.AuthenticatedRequestBuilder)AuthenticatedRequest.authRequestBuilder().method(Set)).params(in)).build());
    }

    default public <E extends Entity> void callSet(EntityDescriptor<E, ?> type, E entity) {
        this.callSet(((EntityParameters.EntityParametersBuilder)((EntityParameters.EntityParametersBuilder)EntityParameters.entityParamsBuilder().typeName(type.name())).entity(entity)).build());
    }

    public void callRemove(AuthenticatedRequest<?> var1);

    default public void callRemove(AuthenticatedParameters in) {
        this.callRemove((AuthenticatedRequest<?>)((AuthenticatedRequest.AuthenticatedRequestBuilder)((AuthenticatedRequest.AuthenticatedRequestBuilder)AuthenticatedRequest.authRequestBuilder().method(Remove)).params(in)).build());
    }

    default public <E extends Entity, S extends Search> void callRemove(EntityDescriptor<E, S> type, E entity) {
        this.callRemove(((EntityParameters.EntityParametersBuilder)((EntityParameters.EntityParametersBuilder)EntityParameters.entityParamsBuilder().typeName(type.name())).entity(entity)).build());
    }

    public <O extends BaseResponse<T>, T> Optional<T> multiCall(MultiCallRequest var1, Class<O> var2);

    public <T> Optional<List<T>> uniformMultiCall(List<? extends BaseRequest<?>> var1, Class<T> var2);

    public MultiCallBuilder buildMultiCall();

    public static <P extends AuthenticatedParameters, R> MethodDescriptor<P, R> method(String name, Class<? super R> result, Class<?> ... parameterClasses) {
        return new MethodDescriptor(name, result, parameterClasses);
    }

    public static <E extends Entity, S extends Search> EntityDescriptor<E, S> entity(Class<E> type) {
        return new EntityDescriptor(type);
    }

    public static class EntityDescriptor<E extends Entity, S extends Search> {
        public final Class<E> type;

        public EntityDescriptor(Class<E> type) {
            this.type = type;
        }

        public String name() {
            return this.type.getSimpleName();
        }

        public String toString() {
            return this.name();
        }
    }

    public static class MethodDescriptor<P extends AuthenticatedParameters, R> {
        public final String name;
        public final Class<? super R> result;
        public final Class<?>[] parameterClasses;

        public MethodDescriptor(String name, Class<? super R> result, Class<?> ... parameterClasses) {
            this.name = name;
            this.result = result;
            this.parameterClasses = parameterClasses;
        }

        public JavaType resultType() {
            if (this.parameterClasses.length == 0) {
                return TypeFactory.defaultInstance().constructType(this.result);
            }
            return TypeFactory.defaultInstance().constructParametricType(this.result, (Class[])this.parameterClasses);
        }

        public String toString() {
            return this.name;
        }
    }

    public static interface MultiCallBuilder {
        public MultiCallBuilder httpHeaders(Map<String, Object> var1);

        public <O extends BaseResponse<T>, T> Supplier<T> call(AuthenticatedRequest<?> var1, Class<O> var2);

        public <T> Supplier<T> callResult(AuthenticatedRequest<?> var1, Class<T> var2);

        public <T> Supplier<List<T>> callResultList(AuthenticatedRequest<?> var1, Class<T> var2);

        public <P extends AuthenticatedParameters, R> Supplier<R> callMethod(MethodDescriptor<P, R> var1, P var2);

        public Supplier<Id> callAdd(AuthenticatedRequest<?> var1);

        default public Supplier<Id> callAdd(AuthenticatedParameters in) {
            return this.callAdd((AuthenticatedRequest<?>)((AuthenticatedRequest.AuthenticatedRequestBuilder)((AuthenticatedRequest.AuthenticatedRequestBuilder)AuthenticatedRequest.authRequestBuilder().method(Api.Add)).params(in)).build());
        }

        default public <E extends Entity> Supplier<Id> callAdd(EntityDescriptor<E, ?> type, E entity) {
            return this.callAdd(((EntityParameters.EntityParametersBuilder)((EntityParameters.EntityParametersBuilder)EntityParameters.entityParamsBuilder().typeName(type.name())).entity(entity)).build());
        }

        public <T extends Entity> Supplier<List<T>> callGet(AuthenticatedRequest<?> var1, Class<T> var2);

        default public <T extends Entity> Supplier<List<T>> callGet(SearchParameters<?> in, Class<T> outT) {
            return this.callGet((AuthenticatedRequest<?>)((AuthenticatedRequest.AuthenticatedRequestBuilder)((AuthenticatedRequest.AuthenticatedRequestBuilder)AuthenticatedRequest.authRequestBuilder().method(Api.Get)).params(in)).build(), outT);
        }

        default public <E extends Entity, S extends Search> Supplier<List<E>> callGet(EntityDescriptor<E, S> type, @Nullable S search) {
            return this.callGet(type, search, null);
        }

        default public <E extends Entity, S extends Search> Supplier<List<E>> callGet(EntityDescriptor<E, S> type, @Nullable S search, @Nullable Integer resultLimit) {
            return this.callGet((SearchParameters<?>)((SearchParameters.SearchParametersBuilder)((Parameters.ParametersBuilder)((SearchParameters.SearchParametersBuilder)SearchParameters.searchParamsBuilder().typeName(type.name())).search(search)).resultsLimit(resultLimit)).build(), (Class)type.type);
        }

        default public <E extends Entity> Supplier<List<E>> callGetAll(EntityDescriptor<E, ?> type) {
            return this.callGet(type, null);
        }

        default public <E extends Entity> Supplier<E> callGetById(EntityDescriptor<E, ?> type, String id) {
            return () -> {
                List o = this.callGet((SearchParameters<?>)((SearchParameters.SearchParametersBuilder)((SearchParameters.SearchParametersBuilder)SearchParameters.searchParamsBuilder().typeName(type.name())).search(new Search(id))).build(), (Class)type.type).get();
                if (o.isEmpty()) {
                    return null;
                }
                if (o.size() > 1) {
                    throw new IllegalStateException("Query by ID returned more than one result");
                }
                return (Entity)o.get(0);
            };
        }

        public Supplier<Integer> callGetCountOf(AuthenticatedRequest<?> var1);

        default public Supplier<Integer> callGetCountOf(SearchParameters<?> in) {
            return this.callGetCountOf((AuthenticatedRequest<?>)((AuthenticatedRequest.AuthenticatedRequestBuilder)((AuthenticatedRequest.AuthenticatedRequestBuilder)AuthenticatedRequest.authRequestBuilder().method(Api.GetCountOf)).params(in)).build());
        }

        default public <E extends Entity, S extends Search> Supplier<Integer> callGetCountOf(EntityDescriptor<E, S> type, S search) {
            return this.callGetCountOf((SearchParameters<?>)((SearchParameters.SearchParametersBuilder)((SearchParameters.SearchParametersBuilder)SearchParameters.searchParamsBuilder().typeName(type.name())).search(search)).build());
        }

        public <T extends Entity> Supplier<FeedResult<T>> callGetFeed(AuthenticatedRequest<?> var1, Class<T> var2);

        default public <T extends Entity> Supplier<FeedResult<T>> callGetFeed(GetFeedParameters<?> in, Class<T> outT) {
            return this.callGetFeed((AuthenticatedRequest<?>)((AuthenticatedRequest.AuthenticatedRequestBuilder)((AuthenticatedRequest.AuthenticatedRequestBuilder)AuthenticatedRequest.authRequestBuilder().method(Api.GetFeed)).params(in)).build(), outT);
        }

        default public <E extends Entity, S extends Search> Supplier<List<E>> callGetFeed(EntityDescriptor<E, S> type, S search, @Nullable String fromVersion, @Nullable Integer resultLimit) {
            return this.callGet(((GetFeedParameters.GetFeedParametersBuilder)((Parameters.ParametersBuilder)((GetFeedParameters.GetFeedParametersBuilder)((GetFeedParameters.GetFeedParametersBuilder)GetFeedParameters.getFeedParamsBuilder().typeName(type.name())).search(search)).fromVersion(fromVersion)).resultsLimit(resultLimit)).build(), type.type);
        }

        public void callSet(AuthenticatedRequest<?> var1);

        default public void callSet(AuthenticatedParameters in) {
            this.callSet((AuthenticatedRequest<?>)((AuthenticatedRequest.AuthenticatedRequestBuilder)((AuthenticatedRequest.AuthenticatedRequestBuilder)AuthenticatedRequest.authRequestBuilder().method(Api.Set)).params(in)).build());
        }

        default public <E extends Entity> void callSet(EntityDescriptor<E, ?> type, E entity) {
            this.callSet(((EntityParameters.EntityParametersBuilder)((EntityParameters.EntityParametersBuilder)EntityParameters.entityParamsBuilder().typeName(type.name())).entity(entity)).build());
        }

        public void callRemove(AuthenticatedRequest<?> var1);

        default public void callRemove(AuthenticatedParameters in) {
            this.callRemove((AuthenticatedRequest<?>)((AuthenticatedRequest.AuthenticatedRequestBuilder)((AuthenticatedRequest.AuthenticatedRequestBuilder)AuthenticatedRequest.authRequestBuilder().method(Api.Remove)).params(in)).build());
        }

        default public <E extends Entity, S extends Search> void callRemove(EntityDescriptor<E, S> type, E entity) {
            this.callRemove(((EntityParameters.EntityParametersBuilder)((EntityParameters.EntityParametersBuilder)EntityParameters.entityParamsBuilder().typeName(type.name())).entity(entity)).build());
        }

        public void execute();
    }
}

