/*
 * Decompiled with CFR 0.152.
 */
package com.geotab.http.exception;

import com.fasterxml.jackson.core.type.TypeReference;
import com.geotab.http.exception.DbUnavailableException;
import com.geotab.http.exception.DbUnavailableState;
import com.geotab.http.exception.DuplicateException;
import com.geotab.http.exception.GroupRelationViolatedException;
import com.geotab.http.exception.InactiveUserException;
import com.geotab.http.exception.InvalidCertificateException;
import com.geotab.http.exception.InvalidMyAdminUserException;
import com.geotab.http.exception.InvalidRequestException;
import com.geotab.http.exception.InvalidUserException;
import com.geotab.http.exception.JsonRpcErrorDataException;
import com.geotab.http.exception.MissingMemberException;
import com.geotab.http.exception.MissingMethodException;
import com.geotab.http.exception.OverLimitException;
import com.geotab.http.exception.PasswordPolicyViolationException;
import com.geotab.http.exception.RegistrationException;
import com.geotab.http.exception.RelationViolatedException;
import com.geotab.http.exception.ServerInvokerJsonException;
import com.geotab.http.response.BaseResponse;
import com.geotab.model.error.JsonRpcError;
import com.geotab.model.error.JsonRpcErrorCode;
import com.geotab.model.error.JsonRpcErrorData;
import com.geotab.model.serialization.ApiJsonSerializer;
import com.geotab.util.Util;
import java.io.IOException;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public final class ErrorHandler {
    public static <R extends BaseResponse<?>> void checkForError(String method, R response) {
        ErrorHandler.checkForError(method, response != null ? response.getError() : null);
    }

    public static void checkForError(String method, @Nullable JsonRpcError error) {
        if (error == null || error.getData() == null) {
            return;
        }
        String formatted = String.format("Error response in call to '%s' [type='%s, message=%s]", method, error.getData().getType(), error.getMessage());
        RuntimeException exception = ErrorHandler.checkForError(formatted, new ServerInvokerJsonException(formatted, null, null, error.getData()), JsonRpcErrorCode.getByCode(error.getCode()), error.getData());
        if (exception instanceof JsonRpcErrorDataException) {
            ((JsonRpcErrorDataException)exception).setErrorData(error.getData());
        }
        throw exception;
    }

    static RuntimeException checkForError(String message, ServerInvokerJsonException ex, JsonRpcErrorCode code, JsonRpcErrorData data) {
        switch (code) {
            case INVALID_REQUEST: {
                return new InvalidRequestException(message, ex);
            }
            case DB_UNAVAILABLE_GENERAL_ERROR: 
            case DB_UNAVAILABLE_CONNECTION_FAILURE: 
            case DB_UNAVAILABLE_INITIALIZING: 
            case DB_UNAVAILABLE_UNKNOWN_DATABASE: 
            case DB_UNAVAILABLE_OPERATION_ABORTED: {
                DbUnavailableState state = DbUnavailableState.NONE;
                if (Util.isNotEmpty(data.getInfo())) {
                    try {
                        Map errorDataInfo = (Map)ApiJsonSerializer.getInstance().getObjectMapper().readValue(data.getInfo(), (TypeReference)new TypeReference<Map<String, DbUnavailableState>>(){});
                        if (errorDataInfo.containsKey("state")) {
                            state = (DbUnavailableState)errorDataInfo.get("state");
                        }
                    }
                    catch (IOException e) {
                        throw new IllegalStateException("Can not deserialize " + data.getInfo() + " to Map");
                    }
                }
                return new DbUnavailableException(message, ex, state);
            }
            case METHOD_NOT_FOUND: {
                return new MissingMethodException(message, ex);
            }
            case PARSE_ERROR: {
                return new JsonRpcErrorDataException(message, ex);
            }
        }
        return ErrorHandler.checkForErrorByErrorDataType(message, ex, data);
    }

    static RuntimeException checkForErrorByErrorDataType(String message, ServerInvokerJsonException ex, JsonRpcErrorData data) {
        switch (data.getType()) {
            case "InvalidMyAdminUserException": {
                String databaseName;
                Map<String, String> innerError;
                if (ex != null && ex.getInnerError() != null && (innerError = ex.getInnerError()).containsKey("message") && Util.isNotEmpty(databaseName = innerError.get("message"))) {
                    return new InvalidMyAdminUserException(databaseName);
                }
                return new InvalidMyAdminUserException();
            }
            case "InvalidUserException": {
                return new InvalidUserException();
            }
            case "InactiveUserException": {
                return new InactiveUserException(null);
            }
            case "DbUnavailableException": {
                return new DbUnavailableException(message, ex, DbUnavailableState.NONE);
            }
            case "RelationViolatedException": {
                return new RelationViolatedException(ex);
            }
            case "GroupRelationViolatedException": {
                return new GroupRelationViolatedException(ex);
            }
            case "DuplicateException": {
                return new DuplicateException(ex);
            }
            case "PasswordPolicyViolationException": {
                return new PasswordPolicyViolationException(message);
            }
            case "RegistrationException": {
                return new RegistrationException(message);
            }
            case "OverLimitException": {
                return new OverLimitException(message);
            }
            case "InvalidRequestException": {
                return new IllegalStateException("Inconsistent JSON-RPC error code");
            }
            case "MethodNotFoundException": 
            case "MissingMethodException": {
                return new MissingMethodException(message, ex);
            }
            case "MissingMemberException": {
                return new MissingMemberException(message, ex);
            }
            case "NullReferenceException": {
                return new NullPointerException(message);
            }
            case "ArgumentException": 
            case "ArgumentOutOfRangeException": {
                return new IllegalArgumentException(message, ex);
            }
            case "JsonSerializerException": 
            case "JSONSerializerException": {
                return new JsonRpcErrorDataException(message, ex);
            }
            case "InvalidCastException": {
                return new ClassCastException(message);
            }
            case "NotSupportedException": {
                return new JsonRpcErrorDataException(message, ex);
            }
            case "InvalidCertificateException": {
                return new InvalidCertificateException(message, ex);
            }
        }
        return ex;
    }
}

