/*
 * Decompiled with CFR 0.152.
 */
package com.geotab.http.invoker;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.geotab.api.Api;
import com.geotab.http.exception.ErrorHandler;
import com.geotab.http.request.BaseRequest;
import com.geotab.http.response.BaseResponse;
import com.geotab.model.error.JsonRpcError;
import com.geotab.model.serialization.ApiJsonSerializer;
import com.geotab.util.Util;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Optional;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.io.entity.HttpEntities;
import org.apache.hc.core5.util.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerInvoker {
    private static final Logger log = LoggerFactory.getLogger(ServerInvoker.class);
    public static final int DEFAULT_TIMEOUT = 300000;
    public static final String DEFAULT_SERVICE_PATH = "apiv1";
    private String url;
    private Integer timeout;
    private String servicePath;
    private CloseableHttpClient httpClient;

    public ServerInvoker(String url) {
        this(url, 300000, DEFAULT_SERVICE_PATH);
    }

    public ServerInvoker(String url, Integer timeout, String servicePath) {
        this(url, timeout, servicePath, null);
    }

    public ServerInvoker(String url, Integer timeout, String servicePath, CloseableHttpClient httpClient) {
        this.servicePath = servicePath;
        this.setUrl(url);
        this.timeout = Optional.ofNullable(timeout).orElse(300000);
        this.httpClient = Optional.ofNullable(httpClient).orElse(this.buildDefaultHttpClient());
        log.debug("ServerInvoker params: \n url = {}  \n timeout = {} \n {}", new Object[]{this.url, this.timeout, httpClient != null ? "custom http client" : "default http client"});
    }

    public CloseableHttpClient getHttpClient() {
        return this.httpClient;
    }

    public String getServicePath() {
        return this.servicePath;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public String getUrl() {
        return this.url;
    }

    private ObjectMapper om() {
        return ApiJsonSerializer.getInstance().getObjectMapper();
    }

    public void setUrl(String url) {
        log.debug("ServerInvoker url set to {}", (Object)url);
        this.url = url + "/" + Optional.ofNullable(this.servicePath).orElse(DEFAULT_SERVICE_PATH);
    }

    public <O extends BaseResponse<T>, T> Optional<T> invoke(BaseRequest<?> in, Class<O> outT) {
        return this.invokeUnsafe(in, this.om().constructType(outT));
    }

    public <T> Optional<T> invoke(BaseRequest<?> in, Api.MethodDescriptor<?, T> method) {
        return this.invokeUnsafe(in, TypeFactory.defaultInstance().constructParametricType(BaseResponse.class, new JavaType[]{method.resultType()}));
    }

    public <O extends BaseResponse<T>, T> Optional<T> invokeUnsafe(BaseRequest<?> in, JavaType outT) {
        return Optional.ofNullable(this.doInvoke(this.url, in, inputStream -> {
            BaseResponse response = (BaseResponse)this.om().readValue(inputStream, outT);
            if (response.getError() != null) {
                ErrorHandler.checkForError(in.getMethod(), response.getError());
            }
            return response;
        })).map(BaseResponse::getResult);
    }

    public Optional<JsonNode> invokeJson(BaseRequest<?> in) {
        return Optional.ofNullable(this.doInvoke(this.url, in, inputStream -> {
            JsonNode response = this.om().readTree(inputStream);
            if (response.hasNonNull("error")) {
                ErrorHandler.checkForError(in.getMethod(), (JsonRpcError)this.om().treeToValue((TreeNode)response.get("error"), JsonRpcError.class));
            }
            return response;
        }).get("result"));
    }

    private <T> T doInvoke(String url, BaseRequest<?> in, Util.FailableFunction<InputStream, T, IOException> decoder) {
        HttpPost httpPost = new HttpPost(url);
        try {
            httpPost.setEntity(HttpEntities.create((String)this.om().writeValueAsString(in), (ContentType)ContentType.APPLICATION_JSON));
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Encoding JSON error", ex);
        }
        if (in.getHttpHeaders() != null && !in.getHttpHeaders().isEmpty()) {
            for (Map.Entry<String, Object> header : in.getHttpHeaders().entrySet()) {
                httpPost.setHeader(header.getKey(), header.getValue());
            }
        }
        try {
            return (T)this.httpClient.execute((ClassicHttpRequest)httpPost, res -> {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[CATCHBLOCK], 1[TRYBLOCK]], but top level block is 4[TRYBLOCK]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            });
        }
        catch (IOException ex) {
            throw new RuntimeException("Invoking request error", ex);
        }
    }

    private CloseableHttpClient buildDefaultHttpClient() {
        return HttpClients.custom().disableAutomaticRetries().disableRedirectHandling().setDefaultRequestConfig(RequestConfig.custom().setConnectTimeout(Timeout.ofSeconds((long)this.timeout.intValue())).setResponseTimeout(Timeout.ofSeconds((long)this.timeout.intValue())).build()).build();
    }

    public void disconnect() {
        try {
            log.debug("Disconnecting http client from {} ...", (Object)this.url);
            if (this.httpClient != null) {
                this.httpClient.close();
            }
            log.info("Disconnected http client from {}", (Object)this.url);
        }
        catch (IOException e) {
            log.error("Can not disconnect http client from {}", (Object)this.url, (Object)e);
        }
    }
}

