/*
 * Decompiled with CFR 0.152.
 */
package com.geotab.model.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.geotab.api.AsString;
import com.geotab.model.Id;
import java.util.Objects;

public abstract class Entity {
    private Id id;

    protected Entity() {
    }

    protected Entity(EntityBuilder<?, ?> b) {
        this.id = b.id;
    }

    @AsString
    public Id getId() {
        return this.id;
    }

    public Entity setId(Id id) {
        this.id = id;
        return this;
    }

    @JsonIgnore
    public boolean isSystemEntity() {
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof Entity)) return false;
        Entity e = (Entity)o;
        if (!Objects.equals(this.getId(), e.getId())) return false;
        return true;
    }

    public final int hashCode() {
        return Objects.hashCode(this.getId());
    }

    public String toString() {
        return "Entity(id=" + String.valueOf(this.getId()) + ")";
    }

    public static abstract class EntityBuilder<C extends Entity, B extends EntityBuilder<C, B>> {
        private Id id;

        public abstract C build();

        public B id(String id) {
            this.id = new Id(id);
            return this.self();
        }

        public B id(Id id) {
            this.id = id;
            return this.self();
        }

        protected abstract B self();

        public String toString() {
            return "Entity.EntityBuilder(id=" + String.valueOf(this.id) + ")";
        }
    }
}

