/*
 * Decompiled with CFR 0.152.
 */
package com.geotab.model.serialization;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.BeanDeserializerFactory;
import com.fasterxml.jackson.databind.deser.ResolvableDeserializer;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.geotab.api.AsString;
import com.geotab.model.Id;
import com.geotab.model.serialization.ObjectMapperExtension;
import com.geotab.model.serialization.SystemEntitySerializationAware;
import com.geotab.model.serialization.serdes.DoubleArraySerializer;
import com.geotab.model.serialization.serdes.DoublePrimitiveArraySerializer;
import com.geotab.model.serialization.serdes.DoubleSerializer;
import com.geotab.model.serialization.serdes.DurationSerde;
import com.geotab.model.serialization.serdes.FloatArraySerializer;
import com.geotab.model.serialization.serdes.FloatPrimitiveArraySerializer;
import com.geotab.model.serialization.serdes.FloatSerializer;
import com.geotab.model.serialization.serdes.IdAsStringSerializer;
import com.geotab.model.serialization.serdes.IdDeserializer;
import com.geotab.model.serialization.serdes.LocalDateTimeDeserializer;
import com.geotab.model.serialization.serdes.LocalDateTimeSerializer;
import com.geotab.model.serialization.serdes.LongDeserializer;
import com.geotab.model.serialization.serdes.LongSerializer;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Optional;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ApiJsonSerializer {
    private final ObjectMapper objectMapper = this.buildDefaultObjectMapper();

    public static ApiJsonSerializer getInstance() {
        return InstanceHolder.INSTANCE;
    }

    private ApiJsonSerializer() {
    }

    public ObjectMapper buildDefaultObjectMapper() {
        JsonMapper om = (JsonMapper)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().enable(new DeserializationFeature[]{DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_USING_DEFAULT_VALUE})).enable(new MapperFeature[]{MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS})).disable(new DeserializationFeature[]{DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES})).serializationInclusion(JsonInclude.Include.NON_NULL)).addModule((Module)new JavaTimeModule())).annotationIntrospector((AnnotationIntrospector)new JacksonAnnotationIntrospector(){

            public Object findSerializer(Annotated a) {
                return a.hasAnnotation(AsString.class) ? new IdAsStringSerializer() : super.findSerializer(a);
            }
        })).addModule((Module)new SimpleModule("id-serialization-module").addDeserializer(Id.class, (JsonDeserializer)new IdDeserializer()))).addModule((Module)new SimpleModule("api-long-serialization-module").addSerializer(Long.TYPE, (JsonSerializer)new LongSerializer()).addSerializer(Long.class, (JsonSerializer)new LongSerializer()).addDeserializer(Long.TYPE, (JsonDeserializer)new LongDeserializer()).addDeserializer(Long.class, (JsonDeserializer)new LongDeserializer()))).addModule((Module)new SimpleModule("api-double-serialization-module").addSerializer(Double.TYPE, (JsonSerializer)new DoubleSerializer()).addSerializer(Double.class, (JsonSerializer)new DoubleSerializer()).addSerializer(double[].class, (JsonSerializer)new DoublePrimitiveArraySerializer()).addSerializer(Double[].class, (JsonSerializer)new DoubleArraySerializer()))).addModule((Module)new SimpleModule("api-float-serialization-module").addSerializer(Float.TYPE, (JsonSerializer)new FloatSerializer()).addSerializer(Float.class, (JsonSerializer)new FloatSerializer()).addSerializer(float[].class, (JsonSerializer)new FloatPrimitiveArraySerializer()).addSerializer(Float[].class, (JsonSerializer)new FloatArraySerializer()))).addModule((Module)new SimpleModule("api-time-serialization-module").addSerializer(LocalDateTime.class, (JsonSerializer)new LocalDateTimeSerializer()).addDeserializer(LocalDateTime.class, (JsonDeserializer)new LocalDateTimeDeserializer()).addSerializer(Duration.class, (JsonSerializer)new DurationSerde.DurationSerializer()).addDeserializer(Duration.class, (JsonDeserializer)new DurationSerde.DurationDeserializer()))).addModule((Module)new SimpleModule("api-custom-serialization-module").setSerializerModifier((BeanSerializerModifier)new SystemEntitySerializerModifier()))).build();
        ServiceLoader<ObjectMapperExtension> loader = ServiceLoader.load(ObjectMapperExtension.class);
        for (ObjectMapperExtension extension : loader) {
            extension.configure((ObjectMapper)om);
        }
        return om;
    }

    public void withCustomObjectMapper(ObjectMapper ignore) {
        throw new UnsupportedOperationException("No longer supported, use ObjectMapperExtension instead.");
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public static <T extends Number> void serializeNumberWithDecimals(T number, JsonGenerator jg) throws IOException {
        BigDecimal i = BigDecimal.valueOf(number.doubleValue()).stripTrailingZeros();
        if (i.signum() == 0 || i.scale() <= 0 || i.remainder(BigDecimal.ONE).compareTo(BigDecimal.ZERO) == 0) {
            jg.writeNumber(i.longValue());
        } else if (number instanceof Float) {
            jg.writeNumber(i.floatValue());
        } else {
            jg.writeNumber(i.doubleValue());
        }
    }

    public static <T> T defaultDeserialize(ObjectCodec oc, DeserializationContext dc, JsonNode jn, Class<T> userType) throws IOException {
        DeserializationConfig config = dc.getConfig();
        JavaType type = TypeFactory.defaultInstance().constructType(userType);
        JsonDeserializer defaultDeserializer = BeanDeserializerFactory.instance.buildBeanDeserializer(dc, type, config.introspect(type));
        if (defaultDeserializer instanceof ResolvableDeserializer) {
            ((ResolvableDeserializer)defaultDeserializer).resolve(dc);
        }
        JsonParser treeParser = oc.treeAsTokens((TreeNode)jn);
        config.initialize(treeParser);
        if (treeParser.getCurrentToken() == null) {
            treeParser.nextToken();
        }
        return (T)defaultDeserializer.deserialize(treeParser, dc);
    }

    private static class InstanceHolder {
        private static final ApiJsonSerializer INSTANCE = new ApiJsonSerializer();

        private InstanceHolder() {
        }
    }

    public static class SystemEntitySerializerModifier
    extends BeanSerializerModifier {
        public JsonSerializer<?> modifySerializer(SerializationConfig sc, BeanDescription bd, JsonSerializer<?> js) {
            if (SystemEntitySerializationAware.class.isAssignableFrom(bd.getBeanClass())) {
                return new MySerializer(js);
            }
            return js;
        }

        private static class MySerializer<T extends SystemEntitySerializationAware>
        extends JsonSerializer<T> {
            private final JsonSerializer<T> defaultSerializer;

            public MySerializer(JsonSerializer<T> defaultSerializer) {
                if (defaultSerializer == null) {
                    throw new IllegalArgumentException("defaultSerializer required");
                }
                this.defaultSerializer = defaultSerializer;
            }

            public void serialize(T t, JsonGenerator jg, SerializerProvider sp) throws IOException {
                if (t == null || t.isSystemEntity()) {
                    jg.writeString((String)Optional.ofNullable(t).map(SystemEntitySerializationAware::getId).map(Id::getId).orElse(null));
                } else {
                    this.defaultSerializer.serialize(t, jg, sp);
                }
            }
        }
    }

    public static class SystemEntitySerializer
    extends JsonSerializer<SystemEntitySerializationAware> {
        private static final Logger log = LoggerFactory.getLogger(SystemEntitySerializer.class);

        public void serialize(SystemEntitySerializationAware o, JsonGenerator jg, SerializerProvider sp) throws IOException {
            if (o == null || o.isSystemEntity()) {
                jg.writeString((String)Optional.ofNullable(o).map(SystemEntitySerializationAware::getId).map(Id::getId).orElse(null));
            } else {
                log.error("Expecting to serialize a system entity type, but it's flag is set to false (marked as not a system entity)!");
            }
        }
    }
}

