/*
 * Decompiled with CFR 0.152.
 */
package com.geotab.model.serialization.serdes;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.geotab.util.Util;
import java.io.IOException;
import java.util.Base64;

public class ByteArrayDeserializer
extends JsonDeserializer<Byte[]> {
    public Byte[] deserialize(JsonParser jsonParser, DeserializationContext context) throws IOException {
        String binaryData;
        ObjectCodec parserCodec = jsonParser.getCodec();
        JsonNode node = (JsonNode)parserCodec.readTree(jsonParser);
        if (node.isTextual() && Util.isNotEmpty(binaryData = node.textValue())) {
            byte[] array = this.getBinaryDataBytes(binaryData);
            Byte[] result = new Byte[array.length];
            for (int i = 0; i < array.length; ++i) {
                result[i] = array[i];
            }
            return result;
        }
        return new Byte[0];
    }

    private byte[] getBinaryDataBytes(String binaryData) {
        try {
            return Base64.getDecoder().decode(binaryData.getBytes());
        }
        catch (IllegalArgumentException exception) {
            return binaryData.getBytes();
        }
    }
}

