/*
 * Decompiled with CFR 0.152.
 */
package com.geotab.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

public interface Util {
    public static boolean isEmpty(@Nullable Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isEmpty(@Nullable String str) {
        return str == null || str.isEmpty();
    }

    public static boolean isNotEmpty(@Nullable String str) {
        return !Util.isEmpty(str);
    }

    public static boolean startWithIc(String prefix, @Nullable String str) {
        if (Util.isEmpty(prefix)) {
            throw new IllegalArgumentException("prefix required");
        }
        if (Util.isEmpty(str)) {
            return false;
        }
        if (prefix == str) {
            return true;
        }
        return str.length() >= prefix.length() && prefix.regionMatches(true, 0, str, 0, prefix.length());
    }

    public static List<?> intersect(@Nullable List<?> firstList, List<?> secondList) {
        if (firstList == null || secondList == null) {
            return Collections.EMPTY_LIST;
        }
        return firstList.stream().distinct().filter(secondList::contains).collect(Collectors.toList());
    }

    @SafeVarargs
    public static <T> List<T> listOf(T ... ts) {
        return new ArrayList<T>(Arrays.asList(ts));
    }

    public static <T, V> MapBuilder<T, V> mapBuilder() {
        return new MapBuilder();
    }

    public static class MapBuilder<T, V> {
        private final HashMap<T, V> out = new HashMap();

        public Map<T, V> build() {
            return this.out;
        }

        public MapBuilder<T, V> put(T key, V value) {
            this.out.put(key, value);
            return this;
        }
    }

    @FunctionalInterface
    public static interface FailableFunction<T, R, E extends Throwable> {
        public R apply(T var1) throws E;
    }
}

