/*
 * Decompiled with CFR 0.152.
 */
package com.github.anicolaspp.ojai;

import com.github.anicolaspp.ojai.DocumentProjector;
import java.util.Arrays;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ojai.Document;
import org.ojai.Value;
import org.ojai.store.Connection;

public class MultiPathProjector {
    private final Document document;
    private final Connection connection;

    public MultiPathProjector(Document document, Connection connection) {
        this.document = document;
        this.connection = connection;
    }

    public Document projectPath(String ... stringArray) {
        if (stringArray.length == 0) {
            return this.document;
        }
        Document document = this.connection.newDocument();
        Arrays.stream(stringArray).forEach(string -> {
            if (string.contains(".")) {
                String string2 = string.replace("\"", "");
                Document document2 = new DocumentProjector(this.document, this.connection).projectPath(string2);
                String[] stringArray = string.replace("[]", "").replace("\"", "").split("\\.");
                if (!document2.isEmpty()) {
                    Value value = document.getValue(stringArray[0]);
                    if (value == null) {
                        document.set(stringArray[0], document2.getValue(stringArray[0]));
                    } else if (value.getType() == Value.Type.ARRAY) {
                        document.set(stringArray[0], Stream.concat(value.getList().stream(), document2.getList(stringArray[0]).stream()).collect(Collectors.toList()));
                    } else if (value.getType() == Value.Type.MAP) {
                        document.set(stringArray[0], value.getMap());
                    }
                }
            } else if (this.document.getValue(string) != null) {
                document.set(string, this.document.getValue(string));
            }
        });
        return document;
    }
}

