/*
 * Decompiled with CFR 0.152.
 */
package com.at.avro.config;

import com.at.avro.AvroField;
import com.at.avro.AvroSchema;
import com.at.avro.AvroType;
import com.at.avro.formatters.ArrayFormatter;
import com.at.avro.formatters.DateFormatter;
import com.at.avro.formatters.DecimalFormatter;
import com.at.avro.formatters.EnumFormatter;
import com.at.avro.formatters.FieldFormatter;
import com.at.avro.formatters.Formatter;
import com.at.avro.formatters.PrimitiveFormatter;
import com.at.avro.formatters.SchemaFormatter;
import com.at.avro.formatters.TypeFormatter;
import com.at.avro.types.Array;
import com.at.avro.types.Date;
import com.at.avro.types.Decimal;
import com.at.avro.types.Enum;
import com.at.avro.types.Primitive;
import java.util.HashMap;
import java.util.Map;

public class FormatterConfig {
    private String indent;
    private String lineSeparator;
    private String colon;
    private boolean prettyPrintFields;
    private boolean prettyPrintSchema;
    private Map<Class, Formatter> formatters = new HashMap<Class, Formatter>(){
        {
            this.put(AvroSchema.class, new SchemaFormatter());
            this.put(AvroField.class, new FieldFormatter());
            this.put(AvroType.class, new TypeFormatter());
            this.put(Date.class, new DateFormatter());
            this.put(Enum.class, new EnumFormatter());
            this.put(Primitive.class, new PrimitiveFormatter());
            this.put(Decimal.class, new DecimalFormatter());
            this.put(Array.class, new ArrayFormatter());
        }
    };

    private FormatterConfig() {
    }

    public String indent() {
        return this.indent;
    }

    public String indent(int times) {
        String result = "";
        for (int i = 0; i < times; ++i) {
            result = result + this.indent();
        }
        return result;
    }

    public String colon() {
        return this.colon;
    }

    public String lineSeparator() {
        return this.lineSeparator;
    }

    public boolean prettyPrintFields() {
        return this.prettyPrintFields;
    }

    public boolean prettyPrintSchema() {
        return this.prettyPrintSchema;
    }

    public <T> Formatter<T> getFormatter(T dto) {
        if (!this.formatters.containsKey(dto.getClass())) {
            throw new IllegalArgumentException("Formatter not found for " + dto.getClass().getSimpleName());
        }
        return this.formatters.get(dto.getClass());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Map<Class, Formatter> formatters = new HashMap<Class, Formatter>();
        private boolean prettyPrintSchema = true;
        private boolean prettyPrintFields = false;
        private boolean addSpaceAfterColon = true;
        private String indent = "  ";

        public <T> Builder setFormatter(Class<T> dtoClass, Formatter<T> formatter) {
            this.formatters.put(dtoClass, formatter);
            return this;
        }

        public Builder setPrettyPrintSchema(boolean prettyPrintSchema) {
            this.prettyPrintSchema = prettyPrintSchema;
            return this;
        }

        public Builder setPrettyPrintFields(boolean prettyPrintFields) {
            this.prettyPrintFields = prettyPrintFields;
            return this;
        }

        public Builder setIndent(String indent) {
            this.indent = indent;
            return this;
        }

        public FormatterConfig build() {
            FormatterConfig config = new FormatterConfig();
            config.formatters.putAll(this.formatters);
            config.lineSeparator = this.prettyPrintSchema ? "\n" : "";
            config.colon = this.addSpaceAfterColon ? ": " : ":";
            config.prettyPrintFields = this.prettyPrintFields && this.prettyPrintSchema;
            config.prettyPrintSchema = this.prettyPrintSchema;
            config.indent = this.prettyPrintSchema ? this.indent : "";
            return config;
        }
    }
}

