/*
 * Decompiled with CFR 0.152.
 */
package com.at.avro.types;

import com.at.avro.config.AvroConfig;
import com.at.avro.types.Type;
import schemacrawler.schema.Column;

public class Decimal
extends Type {
    private final int precision;
    private final int scale;
    private final String javaClass;
    private final String logicalType = "decimal";

    public Decimal(Column column, AvroConfig config) {
        super("string");
        this.precision = column.getSize();
        this.scale = column.getDecimalDigits();
        this.javaClass = config.getDecimalTypeClass().getCanonicalName();
    }

    public String getJavaClass() {
        return this.javaClass;
    }

    public String getLogicalType() {
        return "decimal";
    }

    public int getPrecision() {
        return this.precision;
    }

    public int getScale() {
        return this.scale;
    }

    @Override
    public String toString() {
        return super.toString() + ": " + "decimal" + "[" + this.getPrecision() + ":" + this.getScale() + "]";
    }
}

