/*
 * Decompiled with CFR 0.152.
 */
package com.github.avrokotlin.avro4k.internal.decoder;

import com.github.avrokotlin.avro4k.Avro;
import com.github.avrokotlin.avro4k.internal.ExceptionsKt;
import com.github.avrokotlin.avro4k.internal.HelpersKt;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.AbstractDecoder;
import kotlinx.serialization.encoding.Decoder;
import kotlinx.serialization.modules.SerializersModule;
import org.apache.avro.Schema;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\b \u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u0011\u001a\u00020\u0012J\u0016\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0014H\u0002J2\u0010\u0015\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00142\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u00172\u0006\u0010\u0006\u001a\u00020\u0007H$J2\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00142\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u00172\u0006\u0010\u0006\u001a\u00020\u0007H\u0004J\u001f\u0010\u0018\u001a\u0002H\u0019\"\u0004\b\u0000\u0010\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u00190\u001b\u00a2\u0006\u0002\u0010\u001cJ\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0010\u001a\u00020\u0007H&J\u0006\u0010\u001f\u001a\u00020 J\u000e\u0010!\u001a\u00020\"2\u0006\u0010\u0004\u001a\u00020\u0005R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/github/avrokotlin/avro4k/internal/decoder/AbstractPolymorphicDecoder;", "Lkotlinx/serialization/encoding/AbstractDecoder;", "avro", "Lcom/github/avrokotlin/avro4k/Avro;", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "schema", "Lorg/apache/avro/Schema;", "<init>", "(Lcom/github/avrokotlin/avro4k/Avro;Lkotlinx/serialization/descriptors/SerialDescriptor;Lorg/apache/avro/Schema;)V", "getAvro", "()Lcom/github/avrokotlin/avro4k/Avro;", "serializersModule", "Lkotlinx/serialization/modules/SerializersModule;", "getSerializersModule", "()Lkotlinx/serialization/modules/SerializersModule;", "chosenSchema", "decodeString", "", "tryFindSerialName", "Lkotlin/Pair;", "tryFindSerialNameForUnion", "namesAndAliasesToSerialName", "", "decodeSerializableValue", "T", "deserializer", "Lkotlinx/serialization/DeserializationStrategy;", "(Lkotlinx/serialization/DeserializationStrategy;)Ljava/lang/Object;", "newDecoder", "Lkotlinx/serialization/encoding/Decoder;", "decodeSequentially", "", "decodeElementIndex", "", "core"})
@SourceDebugExtension(value={"SMAP\nAbstractPolymorphicDecoder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractPolymorphicDecoder.kt\ncom/github/avrokotlin/avro4k/internal/decoder/AbstractPolymorphicDecoder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,67:1\n1#2:68\n*E\n"})
public abstract class AbstractPolymorphicDecoder
extends AbstractDecoder {
    @NotNull
    private final Avro avro;
    @NotNull
    private final SerialDescriptor descriptor;
    @NotNull
    private final Schema schema;
    private Schema chosenSchema;

    public AbstractPolymorphicDecoder(@NotNull Avro avro, @NotNull SerialDescriptor descriptor, @NotNull Schema schema) {
        Intrinsics.checkNotNullParameter((Object)avro, (String)"avro");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        this.avro = avro;
        this.descriptor = descriptor;
        this.schema = schema;
    }

    @NotNull
    protected final Avro getAvro() {
        return this.avro;
    }

    @NotNull
    public final SerializersModule getSerializersModule() {
        return this.avro.getSerializersModule();
    }

    @NotNull
    public final String decodeString() {
        Object object;
        block3: {
            block2: {
                Pair<String, Schema> pair;
                object = this.tryFindSerialName();
                if (object == null) break block2;
                Pair<String, Schema> it = pair = object;
                boolean bl = false;
                this.chosenSchema = (Schema)it.getSecond();
                object = (String)pair.getFirst();
                if (object != null) break block3;
            }
            throw new SerializationException("Unknown schema name '" + this.schema.getFullName() + "' for polymorphic type " + this.descriptor.getSerialName() + ". Full schema: " + this.schema);
        }
        return object;
    }

    private final Pair<String, Schema> tryFindSerialName() {
        Map<String, String> namesAndAliasesToSerialName = this.avro.getPolymorphicResolver$core().getFullNamesAndAliasesToSerialName(this.descriptor);
        return this.tryFindSerialName(namesAndAliasesToSerialName, this.schema);
    }

    @Nullable
    protected abstract Pair<String, Schema> tryFindSerialNameForUnion(@NotNull Map<String, String> var1, @NotNull Schema var2);

    @Nullable
    protected final Pair<String, Schema> tryFindSerialName(@NotNull Map<String, String> namesAndAliasesToSerialName, @NotNull Schema schema) {
        Pair pair;
        String string;
        String string2;
        block7: {
            Intrinsics.checkNotNullParameter(namesAndAliasesToSerialName, (String)"namesAndAliasesToSerialName");
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            if (schema.isUnion()) {
                return this.tryFindSerialNameForUnion(namesAndAliasesToSerialName, schema);
            }
            string2 = namesAndAliasesToSerialName.get(schema.getFullName());
            if (string2 == null) {
                Schema schema2;
                Schema it = schema2 = schema;
                boolean bl = false;
                Object object = HelpersKt.isNamedSchema(it) ? schema2 : null;
                if (object != null && (object = object.getAliases()) != null) {
                    for (String it2 : (Iterable)object) {
                        boolean bl2 = false;
                        String string3 = namesAndAliasesToSerialName.get(it2);
                        if (string3 == null) continue;
                        string2 = string3;
                        break block7;
                    }
                    string2 = null;
                } else {
                    string2 = null;
                }
            }
        }
        if ((string = string2) != null) {
            String it = string;
            boolean bl = false;
            pair = TuplesKt.to((Object)it, (Object)schema);
        } else {
            pair = null;
        }
        return pair;
    }

    public final <T> T decodeSerializableValue(@NotNull DeserializationStrategy<? extends T> deserializer) {
        Intrinsics.checkNotNullParameter(deserializer, (String)"deserializer");
        Schema schema = this.chosenSchema;
        if (schema == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"chosenSchema");
            schema = null;
        }
        return (T)this.newDecoder(schema).decodeSerializableValue(deserializer);
    }

    @NotNull
    public abstract Decoder newDecoder(@NotNull Schema var1);

    public final boolean decodeSequentially() {
        return true;
    }

    public final int decodeElementIndex(@NotNull SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        throw ExceptionsKt.IllegalIndexedAccessError((Decoder)this);
    }
}

