/*
 * Decompiled with CFR 0.152.
 */
package com.github.avrokotlin.avro4k.internal.encoder.direct;

import com.github.avrokotlin.avro4k.internal.NumberUtilsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.io.Buffer;
import kotlinx.io.Segment;
import kotlinx.io.SegmentKt;
import kotlinx.io.Sink;
import kotlinx.io.SinksKt;
import kotlinx.io.Utf8Kt;
import kotlinx.io.unsafe.UnsafeBufferOperations;
import org.apache.avro.io.BinaryData;
import org.apache.avro.io.BinaryEncoder;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J \u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\rH\u0016J\b\u0010\u001e\u001a\u00020\u0007H\u0014J\b\u0010\u001f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/github/avrokotlin/avro4k/internal/encoder/direct/KotlinxIoEncoder;", "Lorg/apache/avro/io/BinaryEncoder;", "sink", "Lkotlinx/io/Sink;", "<init>", "(Lkotlinx/io/Sink;)V", "flush", "", "writeBoolean", "b", "", "writeInt", "n", "", "writeLong", "", "writeString", "string", "", "writeFloat", "f", "", "writeDouble", "d", "", "writeFixed", "bytes", "", "start", "len", "writeZero", "bytesBuffered", "core"})
@SourceDebugExtension(value={"SMAP\nKotlinxIoEncoder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinxIoEncoder.kt\ncom/github/avrokotlin/avro4k/internal/encoder/direct/KotlinxIoEncoder\n+ 2 Sinks.kt\nkotlinx/io/SinksKt\n+ 3 UnsafeBufferOperations.kt\nkotlinx/io/unsafe/UnsafeBufferOperations\n*L\n1#1,74:1\n374#2:75\n375#2,2:104\n374#2:106\n375#2,2:135\n195#3,28:76\n195#3,28:107\n*S KotlinDebug\n*F\n+ 1 KotlinxIoEncoder.kt\ncom/github/avrokotlin/avro4k/internal/encoder/direct/KotlinxIoEncoder\n*L\n29#1:75\n29#1:104,2\n38#1:106\n38#1:135,2\n30#1:76,28\n39#1:107,28\n*E\n"})
public final class KotlinxIoEncoder
extends BinaryEncoder {
    @NotNull
    private final Sink sink;

    public KotlinxIoEncoder(@NotNull Sink sink) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        this.sink = sink;
    }

    public void flush() {
        this.sink.flush();
    }

    public void writeBoolean(boolean b) {
        this.sink.writeByte(b ? (byte)1 : 0);
    }

    /*
     * WARNING - void declaration
     */
    public void writeInt(int n) {
        void offset;
        void buffer$iv;
        Sink $this$writeToInternalBuffer$iv = this.sink;
        boolean $i$f$writeToInternalBuffer = false;
        Buffer buffer = $this$writeToInternalBuffer$iv.getBuffer();
        boolean bl = false;
        UnsafeBufferOperations unsafeBufferOperations = UnsafeBufferOperations.INSTANCE;
        Buffer buffer2 = buffer;
        int minimumCapacity$iv = 5;
        boolean $i$f$writeToTail = false;
        Segment tail$iv = buffer$iv.writableSegment(minimumCapacity$iv);
        byte[] data$iv = tail$iv.dataAsByteArray(false);
        int cfr_ignored_0 = data$iv.length;
        int n2 = tail$iv.getLimit();
        byte[] bytes = data$iv;
        boolean bl2 = false;
        int bytesWritten$iv = BinaryData.encodeInt((int)n, (byte[])bytes, (int)offset);
        if (bytesWritten$iv == minimumCapacity$iv) {
            tail$iv.writeBackData(data$iv, bytesWritten$iv);
            tail$iv.setLimit(tail$iv.getLimit() + bytesWritten$iv);
            buffer$iv.setSizeMut(buffer$iv.getSizeMut() + (long)bytesWritten$iv);
        } else {
            if (!(0 <= bytesWritten$iv ? bytesWritten$iv <= tail$iv.getRemainingCapacity() : false)) {
                boolean bl3 = false;
                String string = "Invalid number of bytes written: " + bytesWritten$iv + ". Should be in 0.." + tail$iv.getRemainingCapacity();
                throw new IllegalStateException(string.toString());
            }
            if (bytesWritten$iv != 0) {
                tail$iv.writeBackData(data$iv, bytesWritten$iv);
                tail$iv.setLimit(tail$iv.getLimit() + bytesWritten$iv);
                buffer$iv.setSizeMut(buffer$iv.getSizeMut() + (long)bytesWritten$iv);
            } else if (SegmentKt.isEmpty((Segment)tail$iv)) {
                buffer$iv.recycleTail();
            }
        }
        $this$writeToInternalBuffer$iv.hintEmit();
    }

    /*
     * WARNING - void declaration
     */
    public void writeLong(long n) {
        void offset;
        void buffer$iv;
        Sink $this$writeToInternalBuffer$iv = this.sink;
        boolean $i$f$writeToInternalBuffer = false;
        Buffer buffer = $this$writeToInternalBuffer$iv.getBuffer();
        boolean bl = false;
        UnsafeBufferOperations unsafeBufferOperations = UnsafeBufferOperations.INSTANCE;
        Buffer buffer2 = buffer;
        int minimumCapacity$iv = 10;
        boolean $i$f$writeToTail = false;
        Segment tail$iv = buffer$iv.writableSegment(minimumCapacity$iv);
        byte[] data$iv = tail$iv.dataAsByteArray(false);
        int cfr_ignored_0 = data$iv.length;
        int n2 = tail$iv.getLimit();
        byte[] bytes = data$iv;
        boolean bl2 = false;
        int bytesWritten$iv = BinaryData.encodeLong((long)n, (byte[])bytes, (int)offset);
        if (bytesWritten$iv == minimumCapacity$iv) {
            tail$iv.writeBackData(data$iv, bytesWritten$iv);
            tail$iv.setLimit(tail$iv.getLimit() + bytesWritten$iv);
            buffer$iv.setSizeMut(buffer$iv.getSizeMut() + (long)bytesWritten$iv);
        } else {
            if (!(0 <= bytesWritten$iv ? bytesWritten$iv <= tail$iv.getRemainingCapacity() : false)) {
                boolean bl3 = false;
                String string = "Invalid number of bytes written: " + bytesWritten$iv + ". Should be in 0.." + tail$iv.getRemainingCapacity();
                throw new IllegalStateException(string.toString());
            }
            if (bytesWritten$iv != 0) {
                tail$iv.writeBackData(data$iv, bytesWritten$iv);
                tail$iv.setLimit(tail$iv.getLimit() + bytesWritten$iv);
                buffer$iv.setSizeMut(buffer$iv.getSizeMut() + (long)bytesWritten$iv);
            } else if (SegmentKt.isEmpty((Segment)tail$iv)) {
                buffer$iv.recycleTail();
            }
        }
        $this$writeToInternalBuffer$iv.hintEmit();
    }

    public void writeString(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        if (((CharSequence)string).length() == 0) {
            this.writeZero();
            return;
        }
        this.writeInt(string.length());
        Utf8Kt.writeString$default((Sink)this.sink, (String)string, (int)0, (int)0, (int)6, null);
    }

    public void writeFloat(float f) {
        SinksKt.writeFloatLe((Sink)this.sink, (float)f);
    }

    public void writeDouble(double d) {
        SinksKt.writeDoubleLe((Sink)this.sink, (double)d);
    }

    public void writeFixed(@NotNull byte[] bytes, int start, int len) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        this.sink.write(bytes, start, len);
    }

    protected void writeZero() {
        this.sink.writeByte((byte)0);
    }

    public int bytesBuffered() {
        return NumberUtilsKt.toIntExact(this.sink.getBuffer().getSize());
    }
}

