/*
 * Decompiled with CFR 0.152.
 */
package com.github.avrokotlin.avro4k.internal.encoder.generic;

import com.github.avrokotlin.avro4k.Avro;
import com.github.avrokotlin.avro4k.internal.encoder.generic.AbstractRecordGenericEncoder;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.descriptors.SerialDescriptor;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0018\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u00a2\u0006\u0004\b\f\u0010\rJ\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/github/avrokotlin/avro4k/internal/encoder/generic/RecordContiguousSkippingEncoder;", "Lcom/github/avrokotlin/avro4k/internal/encoder/generic/AbstractRecordGenericEncoder;", "skippedElements", "", "schema", "Lorg/apache/avro/Schema;", "avro", "Lcom/github/avrokotlin/avro4k/Avro;", "onEncoded", "Lkotlin/Function1;", "Lorg/apache/avro/generic/GenericRecord;", "", "<init>", "([ZLorg/apache/avro/Schema;Lcom/github/avrokotlin/avro4k/Avro;Lkotlin/jvm/functions/Function1;)V", "nextWriterFieldIndex", "", "encodeElement", "", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "index", "core"})
final class RecordContiguousSkippingEncoder
extends AbstractRecordGenericEncoder {
    @NotNull
    private final boolean[] skippedElements;
    private int nextWriterFieldIndex;

    public RecordContiguousSkippingEncoder(@NotNull boolean[] skippedElements, @NotNull Schema schema, @NotNull Avro avro, @NotNull Function1<? super GenericRecord, Unit> onEncoded) {
        Intrinsics.checkNotNullParameter((Object)skippedElements, (String)"skippedElements");
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        Intrinsics.checkNotNullParameter((Object)avro, (String)"avro");
        Intrinsics.checkNotNullParameter(onEncoded, (String)"onEncoded");
        super(avro, schema, onEncoded);
        this.skippedElements = skippedElements;
    }

    @Override
    public boolean encodeElement(@NotNull SerialDescriptor descriptor, int index) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        if (this.skippedElements[index]) {
            return false;
        }
        super.encodeElement(descriptor, index);
        int n = this.nextWriterFieldIndex;
        this.nextWriterFieldIndex = n + 1;
        this.setWriterField(n);
        return true;
    }
}

