/*
 * Decompiled with CFR 0.152.
 */
package com.github.avrokotlin.avro4k.internal;

import com.github.avrokotlin.avro4k.Avro;
import com.github.avrokotlin.avro4k.AvroDefault;
import com.github.avrokotlin.avro4k.internal.DecodingStep;
import com.github.avrokotlin.avro4k.internal.EncodingWorkflow;
import com.github.avrokotlin.avro4k.internal.HelpersKt;
import com.github.avrokotlin.avro4k.internal.RecordResolverKt;
import com.github.avrokotlin.avro4k.internal.SerializationWorkflow;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.WeakHashMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.descriptors.SerialDescriptor;
import org.apache.avro.Schema;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\tJ\u0018\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\nH\u0002J#\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\nH\u0002\u00a2\u0006\u0002\u0010\u0013J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\nH\u0002J\u001e\u0010\u0016\u001a\u0004\u0018\u00010\u0017*\u00020\n2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0014\u0010\u001a\u001a\u00020\u001b*\u00020\n2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0006\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u0012\u0004\u0012\u00020\u000b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/github/avrokotlin/avro4k/internal/RecordResolver;", "", "avro", "Lcom/github/avrokotlin/avro4k/Avro;", "<init>", "(Lcom/github/avrokotlin/avro4k/Avro;)V", "fieldCache", "", "Lkotlin/Pair;", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "Lorg/apache/avro/Schema;", "Lcom/github/avrokotlin/avro4k/internal/SerializationWorkflow;", "resolveFields", "writerSchema", "classDescriptor", "loadCache", "computeDecodingSteps", "", "Lcom/github/avrokotlin/avro4k/internal/DecodingStep;", "(Lkotlinx/serialization/descriptors/SerialDescriptor;Lorg/apache/avro/Schema;)[Lcom/github/avrokotlin/avro4k/internal/DecodingStep;", "computeEncodingWorkflow", "Lcom/github/avrokotlin/avro4k/internal/EncodingWorkflow;", "findFieldMatchingWithElement", "Lorg/apache/avro/Schema$Field;", "elementIndex", "", "isTypeOf", "", "expectedType", "Lorg/apache/avro/Schema$Type;", "core"})
@SourceDebugExtension(value={"SMAP\nRecordResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RecordResolver.kt\ncom/github/avrokotlin/avro4k/internal/RecordResolver\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 helpers.kt\ncom/github/avrokotlin/avro4k/internal/HelpersKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 7 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,389:1\n382#2,7:390\n1878#3,3:397\n230#3,2:406\n230#3,2:408\n230#3,2:410\n1761#3,3:423\n13040#4,2:400\n13940#4,2:402\n13942#4:412\n13940#4,3:415\n11591#4:418\n11926#4,3:419\n31#5:404\n1#6:405\n1#6:422\n37#7,2:413\n*S KotlinDebug\n*F\n+ 1 RecordResolver.kt\ncom/github/avrokotlin/avro4k/internal/RecordResolver\n*L\n50#1:390,7\n98#1:397,3\n140#1:406,2\n146#1:408,2\n152#1:410,2\n218#1:423,3\n113#1:400,2\n120#1:402,2\n120#1:412\n197#1:415,3\n208#1:418\n208#1:419,3\n123#1:404\n123#1:405\n160#1:413,2\n*E\n"})
public final class RecordResolver {
    @NotNull
    private final Avro avro;
    @NotNull
    private final Map<Pair<SerialDescriptor, Schema>, SerializationWorkflow> fieldCache;

    public RecordResolver(@NotNull Avro avro) {
        Intrinsics.checkNotNullParameter((Object)avro, (String)"avro");
        this.avro = avro;
        this.fieldCache = new WeakHashMap();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final SerializationWorkflow resolveFields(@NotNull Schema writerSchema, @NotNull SerialDescriptor classDescriptor) {
        Object object;
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)writerSchema, (String)"writerSchema");
        Intrinsics.checkNotNullParameter((Object)classDescriptor, (String)"classDescriptor");
        Map<Pair<SerialDescriptor, Schema>, SerializationWorkflow> map = this.fieldCache;
        Pair key$iv = TuplesKt.to((Object)classDescriptor, (Object)writerSchema);
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            SerializationWorkflow answer$iv = this.loadCache(classDescriptor, writerSchema);
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (SerializationWorkflow)object;
    }

    private final SerializationWorkflow loadCache(SerialDescriptor classDescriptor, Schema writerSchema) {
        return new SerializationWorkflow(this.computeDecodingSteps(classDescriptor, writerSchema), this.computeEncodingWorkflow(classDescriptor, writerSchema));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private final DecodingStep[] computeDecodingSteps(SerialDescriptor classDescriptor, Schema writerSchema) {
        List decodingSteps;
        block20: {
            boolean bl;
            Object object;
            Collection collection;
            int writerFieldIndex;
            boolean[] visitedElements;
            block18: {
                decodingSteps = new ArrayList();
                int n = 0;
                int n2 = writerSchema.getFields().size();
                Integer[] integerArray = new Integer[n2];
                while (n < n2) {
                    int n3 = n++;
                    integerArray[n3] = null;
                }
                Integer[] writerFieldIndexToElementIndex = integerArray;
                n2 = classDescriptor.getElementsCount();
                for (int elementIndex = 0; elementIndex < n2; ++elementIndex) {
                    Schema.Field writerField;
                    if (this.findFieldMatchingWithElement(writerSchema, classDescriptor, elementIndex) == null) continue;
                    if (writerFieldIndexToElementIndex[writerField.pos()] != null) {
                        throw new IllegalStateException("The descriptor " + classDescriptor + " has multiple elements matching to the same writer field '" + writerField + "'. This is not allowed as it would lead to ambiguous decoding.");
                    }
                    writerFieldIndexToElementIndex[writerField.pos()] = elementIndex;
                }
                n2 = 0;
                int writerField = classDescriptor.getElementsCount();
                boolean[] blArray = new boolean[writerField];
                while (n2 < writerField) {
                    int n4 = n2++;
                    blArray[n4] = false;
                }
                visitedElements = blArray;
                List list = writerSchema.getFields();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getFields(...)");
                Iterable $this$forEachIndexed$iv = list;
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (Object item$iv : $this$forEachIndexed$iv) {
                    DecodingStep decodingStep;
                    int n5;
                    if ((n5 = index$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    Schema.Field field = (Schema.Field)item$iv;
                    writerFieldIndex = n5;
                    boolean bl2 = false;
                    Integer elementIndex = writerFieldIndexToElementIndex[writerFieldIndex];
                    collection = decodingSteps;
                    if (elementIndex != null) {
                        visitedElements[elementIndex.intValue()] = true;
                        int n6 = elementIndex;
                        Schema schema = field.schema();
                        Intrinsics.checkNotNullExpressionValue((Object)schema, (String)"schema(...)");
                        decodingStep = new DecodingStep.DeserializeWriterField(n6, writerFieldIndex, schema);
                    } else {
                        Schema schema = field.schema();
                        Intrinsics.checkNotNullExpressionValue((Object)schema, (String)"schema(...)");
                        decodingStep = new DecodingStep.SkipWriterField(writerFieldIndex, schema);
                    }
                    object = decodingStep;
                    collection.add(object);
                }
                boolean[] $this$any$iv = visitedElements;
                boolean $i$f$any = false;
                int n7 = $this$any$iv.length;
                for (index$iv = 0; index$iv < n7; ++index$iv) {
                    boolean element$iv;
                    boolean it = element$iv = $this$any$iv[index$iv];
                    boolean bl3 = false;
                    if (!(!it)) continue;
                    bl = true;
                    break block18;
                }
                bl = false;
            }
            if (!bl) break block20;
            Schema readerSchema = this.avro.schema(classDescriptor);
            boolean[] $this$forEachIndexed$iv = visitedElements;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (int n : $this$forEachIndexed$iv) {
                DecodingStep decodingStep;
                block22: {
                    Object element$iv;
                    Schema it;
                    Iterable $this$first$iv;
                    int n8;
                    Schema.Field readerField;
                    Iterator iterator;
                    int elementIndex;
                    block28: {
                        Object element$iv2;
                        block26: {
                            Object element$iv3;
                            block24: {
                                block27: {
                                    block25: {
                                        block23: {
                                            block21: {
                                                Annotation annotation;
                                                block19: {
                                                    void $this$findElementAnnotation$iv;
                                                    void visited;
                                                    int n9 = index$iv++;
                                                    writerFieldIndex = n;
                                                    elementIndex = n9;
                                                    boolean bl4 = false;
                                                    if (visited != false) continue;
                                                    collection = classDescriptor;
                                                    int elementIndex$iv = elementIndex;
                                                    boolean $i$f$findElementAnnotation = false;
                                                    for (Annotation it$iv : (Iterable)$this$findElementAnnotation$iv.getElementAnnotations(elementIndex$iv)) {
                                                        boolean bl5 = false;
                                                        Annotation annotation2 = it$iv;
                                                        if (!(annotation2 instanceof AvroDefault)) {
                                                            annotation2 = null;
                                                        }
                                                        if ((iterator = (Annotation)((AvroDefault)annotation2)) == null) continue;
                                                        annotation = iterator;
                                                        break block19;
                                                    }
                                                    annotation = null;
                                                }
                                                AvroDefault readerDefaultAnnotation = (AvroDefault)annotation;
                                                readerField = (Schema.Field)readerSchema.getFields().get(elementIndex);
                                                object = decodingSteps;
                                                if (readerDefaultAnnotation == null) break block21;
                                                Schema schema = readerField.schema();
                                                Intrinsics.checkNotNullExpressionValue((Object)schema, (String)"schema(...)");
                                                Schema schema2 = readerField.schema();
                                                Intrinsics.checkNotNullExpressionValue((Object)schema2, (String)"schema(...)");
                                                decodingStep = new DecodingStep.GetDefaultValue(elementIndex, schema, RecordResolverKt.access$parseValueToGenericData(readerDefaultAnnotation, schema2));
                                                break block22;
                                            }
                                            if (!classDescriptor.isElementOptional(elementIndex)) break block23;
                                            decodingStep = new DecodingStep.IgnoreOptionalElement(elementIndex);
                                            break block22;
                                        }
                                        if (this.avro.getConfiguration().getImplicitNulls() && readerField.schema().isNullable()) break block24;
                                        if (!this.avro.getConfiguration().getImplicitEmptyCollections()) break block25;
                                        Schema schema = readerField.schema();
                                        Intrinsics.checkNotNullExpressionValue((Object)schema, (String)"schema(...)");
                                        if (this.isTypeOf(schema, Schema.Type.ARRAY)) break block26;
                                    }
                                    if (!this.avro.getConfiguration().getImplicitEmptyCollections()) break block27;
                                    Schema schema = readerField.schema();
                                    Intrinsics.checkNotNullExpressionValue((Object)schema, (String)"schema(...)");
                                    if (this.isTypeOf(schema, Schema.Type.MAP)) break block28;
                                }
                                decodingStep = new DecodingStep.MissingElementValueFailure(elementIndex);
                                break block22;
                            }
                            Schema schema = readerField.schema();
                            Intrinsics.checkNotNullExpressionValue((Object)schema, (String)"schema(...)");
                            Iterable $i$f$findElementAnnotation = HelpersKt.asSchemaList(schema);
                            n8 = elementIndex;
                            boolean $i$f$first = false;
                            iterator = $this$first$iv.iterator();
                            do {
                                if (!iterator.hasNext()) {
                                    throw new NoSuchElementException("Collection contains no element matching the predicate.");
                                }
                                element$iv3 = iterator.next();
                                it = (Schema)element$iv3;
                                boolean bl6 = false;
                            } while (!(it.getType() == Schema.Type.NULL));
                            Object e = element$iv3;
                            Object var27_53 = null;
                            Schema schema3 = (Schema)e;
                            int n10 = n8;
                            decodingStep = new DecodingStep.GetDefaultValue(n10, schema3, var27_53);
                            break block22;
                        }
                        Schema schema = readerField.schema();
                        Intrinsics.checkNotNullExpressionValue((Object)schema, (String)"schema(...)");
                        $this$first$iv = HelpersKt.asSchemaList(schema);
                        n8 = elementIndex;
                        boolean $i$f$first = false;
                        iterator = $this$first$iv.iterator();
                        do {
                            if (!iterator.hasNext()) {
                                throw new NoSuchElementException("Collection contains no element matching the predicate.");
                            }
                            element$iv2 = iterator.next();
                            it = (Schema)element$iv2;
                            boolean bl7 = false;
                        } while (!(it.getType() == Schema.Type.ARRAY));
                        Object t = element$iv2;
                        List list = CollectionsKt.emptyList();
                        Schema schema4 = (Schema)t;
                        int n11 = n8;
                        decodingStep = new DecodingStep.GetDefaultValue(n11, schema4, list);
                        break block22;
                    }
                    Schema schema = readerField.schema();
                    Intrinsics.checkNotNullExpressionValue((Object)schema, (String)"schema(...)");
                    $this$first$iv = HelpersKt.asSchemaList(schema);
                    n8 = elementIndex;
                    boolean $i$f$first = false;
                    iterator = $this$first$iv.iterator();
                    do {
                        if (!iterator.hasNext()) {
                            throw new NoSuchElementException("Collection contains no element matching the predicate.");
                        }
                        element$iv = iterator.next();
                        it = (Schema)element$iv;
                        boolean bl8 = false;
                    } while (!(it.getType() == Schema.Type.MAP));
                    Object t = element$iv;
                    Map map = MapsKt.emptyMap();
                    Schema schema5 = (Schema)t;
                    int n12 = n8;
                    decodingStep = new DecodingStep.GetDefaultValue(n12, schema5, map);
                }
                DecodingStep decodingStep2 = decodingStep;
                object.add(decodingStep2);
            }
        }
        Collection $this$toTypedArray$iv = decodingSteps;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new DecodingStep[0]);
    }

    /*
     * WARNING - void declaration
     */
    private final EncodingWorkflow computeEncodingWorkflow(SerialDescriptor classDescriptor, Schema writerSchema) {
        EncodingWorkflow encodingWorkflow;
        boolean bl;
        int n;
        List missingWriterFieldsIndexes = new ArrayList();
        int n2 = 0;
        int n22 = writerSchema.getFields().size();
        boolean[] blArray = new boolean[n22];
        while (n2 < n22) {
            int n3 = n2++;
            blArray[n3] = false;
        }
        boolean[] visitedWriterFields = blArray;
        n22 = 0;
        int n4 = classDescriptor.getElementsCount();
        int[] nArray = new int[n4];
        while (n22 < n4) {
            int n5 = n22++;
            nArray[n5] = -1;
        }
        int[] descriptorToWriterFieldIndex = nArray;
        int expectedNextWriterIndex = 0;
        int n6 = classDescriptor.getElementsCount();
        for (int elementIndex = 0; elementIndex < n6; ++elementIndex) {
            Schema.Field writerField;
            if (this.findFieldMatchingWithElement(writerSchema, classDescriptor, elementIndex) == null) continue;
            if (visitedWriterFields[writerField.pos()]) {
                throw new IllegalStateException("The descriptor " + classDescriptor + " has multiple elements matching to the same writer field '" + writerField + "'. This is not allowed as it would lead to ambiguous encoding.");
            }
            visitedWriterFields[writerField.pos()] = true;
            descriptorToWriterFieldIndex[elementIndex] = writerField.pos();
            if (expectedNextWriterIndex == -1) continue;
            if (writerField.pos() != expectedNextWriterIndex) {
                expectedNextWriterIndex = -1;
                continue;
            }
            ++expectedNextWriterIndex;
        }
        boolean[] $this$forEachIndexed$iv = visitedWriterFields;
        boolean $i$f$forEachIndexed = false;
        int index$iv22 = 0;
        for (int n3 : $this$forEachIndexed$iv) {
            void visited;
            int n5 = index$iv22++;
            n = n3;
            int writerFieldIndex = n5;
            bl = false;
            if (visited != false) continue;
            ((Collection)missingWriterFieldsIndexes).add(writerFieldIndex);
        }
        if (!((Collection)missingWriterFieldsIndexes).isEmpty()) {
            encodingWorkflow = new EncodingWorkflow.MissingWriterFields(missingWriterFieldsIndexes);
        } else if (expectedNextWriterIndex == -1) {
            encodingWorkflow = new EncodingWorkflow.NonContiguous(descriptorToWriterFieldIndex);
        } else if (classDescriptor.getElementsCount() != writerSchema.getFields().size()) {
            void var12_23;
            void $this$mapTo$iv$iv;
            int[] $this$map$iv = descriptorToWriterFieldIndex;
            boolean $i$f$map = false;
            int[] index$iv22 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            boolean bl2 = false;
            n = ((void)$this$mapTo$iv$iv).length;
            while (var12_23 < n) {
                void it;
                void item$iv$iv = $this$mapTo$iv$iv[var12_23];
                bl = item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl22 = false;
                collection.add(it == -1);
                ++var12_23;
            }
            boolean[] blArray2 = CollectionsKt.toBooleanArray((Collection)((List)destination$iv$iv));
            encodingWorkflow = new EncodingWorkflow.ContiguousWithSkips(blArray2);
        } else {
            encodingWorkflow = EncodingWorkflow.ExactMatch.INSTANCE;
        }
        return encodingWorkflow;
    }

    private final Schema.Field findFieldMatchingWithElement(Schema $this$findFieldMatchingWithElement, SerialDescriptor classDescriptor, int elementIndex) {
        Schema.Field field;
        block2: {
            field = RecordResolverKt.access$findFieldNamedOrAliasedAs($this$findFieldMatchingWithElement, this.avro.getConfiguration().getFieldNamingStrategy().resolve(classDescriptor, elementIndex));
            if (field == null) {
                for (String it : (Iterable)HelpersKt.getElementAliases(classDescriptor, elementIndex)) {
                    boolean bl = false;
                    Schema.Field field2 = RecordResolverKt.access$findFieldNamedOrAliasedAs($this$findFieldMatchingWithElement, it);
                    if (field2 == null) continue;
                    field = field2;
                    break block2;
                }
                field = null;
            }
        }
        return field;
    }

    private final boolean isTypeOf(Schema $this$isTypeOf, Schema.Type expectedType) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = HelpersKt.asSchemaList($this$isTypeOf);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Schema it = (Schema)element$iv;
                    boolean bl2 = false;
                    if (!(it.getType() == expectedType)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }
}

