/*
 * Decompiled with CFR 0.152.
 */
package com.github.avrokotlin.avro4k.internal.decoder.generic;

import com.github.avrokotlin.avro4k.Avro;
import com.github.avrokotlin.avro4k.AvroDecoder;
import com.github.avrokotlin.avro4k.internal.ExceptionsKt;
import com.github.avrokotlin.avro4k.internal.NumberUtilsKt;
import com.github.avrokotlin.avro4k.internal.SerializerLocatorMiddleware;
import com.github.avrokotlin.avro4k.internal.decoder.generic.ArrayGenericDecoder;
import com.github.avrokotlin.avro4k.internal.decoder.generic.MapGenericDecoder;
import com.github.avrokotlin.avro4k.internal.decoder.generic.PolymorphicGenericDecoder;
import com.github.avrokotlin.avro4k.internal.decoder.generic.RecordGenericDecoder;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.descriptors.PolymorphicKind;
import kotlinx.serialization.descriptors.PrimitiveKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialKind;
import kotlinx.serialization.descriptors.StructureKind;
import kotlinx.serialization.encoding.AbstractDecoder;
import kotlinx.serialization.encoding.CompositeDecoder;
import kotlinx.serialization.encoding.Decoder;
import kotlinx.serialization.modules.SerializersModule;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericArray;
import org.apache.avro.generic.GenericContainer;
import org.apache.avro.generic.GenericEnumSymbol;
import org.apache.avro.generic.GenericFixed;
import org.apache.avro.generic.IndexedRecord;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\n\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\b \u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\t\u001a\u00020\nH&J\b\u0010\u000b\u001a\u00020\fH&J!\u0010\u0011\u001a\u0002H\u0012\"\u0004\b\u0000\u0010\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00120\u0014H\u0016\u00a2\u0006\u0002\u0010\u0015J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\nH\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020$H\u0016J\b\u0010%\u001a\u00020&H\u0016J\b\u0010'\u001a\u00020(H\u0016J\b\u0010)\u001a\u00020*H\u0016J\u0010\u0010+\u001a\u00020 2\u0006\u0010,\u001a\u00020\u0019H\u0016J\b\u0010-\u001a\u00020.H\u0016J\b\u0010/\u001a\u000200H\u0016R\u0012\u0010\u0005\u001a\u00020\u0006X\u00a0\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u00061"}, d2={"Lcom/github/avrokotlin/avro4k/internal/decoder/generic/AbstractAvroGenericDecoder;", "Lkotlinx/serialization/encoding/AbstractDecoder;", "Lcom/github/avrokotlin/avro4k/AvroDecoder;", "<init>", "()V", "avro", "Lcom/github/avrokotlin/avro4k/Avro;", "getAvro$core", "()Lcom/github/avrokotlin/avro4k/Avro;", "decodeNotNullMark", "", "decodeValue", "", "serializersModule", "Lkotlinx/serialization/modules/SerializersModule;", "getSerializersModule", "()Lkotlinx/serialization/modules/SerializersModule;", "decodeSerializableValue", "T", "deserializer", "Lkotlinx/serialization/DeserializationStrategy;", "(Lkotlinx/serialization/DeserializationStrategy;)Ljava/lang/Object;", "beginStructure", "Lkotlinx/serialization/encoding/CompositeDecoder;", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "decodeBoolean", "decodeByte", "", "decodeShort", "", "decodeInt", "", "decodeLong", "", "decodeFloat", "", "decodeDouble", "", "decodeChar", "", "decodeString", "", "decodeEnum", "enumDescriptor", "decodeBytes", "", "decodeFixed", "Lorg/apache/avro/generic/GenericFixed;", "core"})
@SourceDebugExtension(value={"SMAP\nAbstractAvroGenericDecoder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractAvroGenericDecoder.kt\ncom/github/avrokotlin/avro4k/internal/decoder/generic/AbstractAvroGenericDecoder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 exceptions.kt\ncom/github/avrokotlin/avro4k/internal/ExceptionsKt\n*L\n1#1,211:1\n1#2:212\n34#3,9:213\n34#3,9:222\n*S KotlinDebug\n*F\n+ 1 AbstractAvroGenericDecoder.kt\ncom/github/avrokotlin/avro4k/internal/decoder/generic/AbstractAvroGenericDecoder\n*L\n201#1:213,9\n208#1:222,9\n*E\n"})
public abstract class AbstractAvroGenericDecoder
extends AbstractDecoder
implements AvroDecoder {
    @NotNull
    public abstract Avro getAvro$core();

    public abstract boolean decodeNotNullMark();

    @Override
    @NotNull
    public abstract Object decodeValue();

    @NotNull
    public SerializersModule getSerializersModule() {
        return this.getAvro$core().getSerializersModule();
    }

    public <T> T decodeSerializableValue(@NotNull DeserializationStrategy<? extends T> deserializer) {
        Intrinsics.checkNotNullParameter(deserializer, (String)"deserializer");
        return (T)SerializerLocatorMiddleware.INSTANCE.apply(deserializer).deserialize((Decoder)this);
    }

    @NotNull
    public CompositeDecoder beginStructure(@NotNull SerialDescriptor descriptor) {
        CompositeDecoder compositeDecoder;
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        SerialKind serialKind = descriptor.getKind();
        if (Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.LIST.INSTANCE)) {
            ArrayGenericDecoder arrayGenericDecoder;
            Object value = this.decodeValue();
            if (value instanceof GenericArray) {
                Collection collection = (Collection)value;
                Schema schema = ((GenericArray)value).getSchema();
                Intrinsics.checkNotNullExpressionValue((Object)schema, (String)"getSchema(...)");
                arrayGenericDecoder = new ArrayGenericDecoder(collection, schema, this.getAvro$core());
            } else if (value instanceof Collection) {
                arrayGenericDecoder = new ArrayGenericDecoder((Collection)value, this.getCurrentWriterSchema(), this.getAvro$core());
            } else {
                KClass[] kClassArray = new KClass[]{Reflection.getOrCreateKotlinClass(Collection.class), Reflection.getOrCreateKotlinClass(ByteBuffer.class)};
                throw ExceptionsKt.BadDecodedValueError((Decoder)this, value, (SerialKind)StructureKind.LIST.INSTANCE, Reflection.getOrCreateKotlinClass(GenericArray.class), kClassArray);
            }
            compositeDecoder = (CompositeDecoder)arrayGenericDecoder;
        } else if (Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.MAP.INSTANCE)) {
            Object value = this.decodeValue();
            if (!(value instanceof Map)) {
                throw ExceptionsKt.BadDecodedValueError((Decoder)this, value, (SerialKind)StructureKind.MAP.INSTANCE, Reflection.getOrCreateKotlinClass(Map.class), new KClass[0]);
            }
            compositeDecoder = (CompositeDecoder)new MapGenericDecoder((Map)value, this.getCurrentWriterSchema(), this.getAvro$core());
        } else if (Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.CLASS.INSTANCE) || Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.OBJECT.INSTANCE)) {
            Object value = this.decodeValue();
            if (!(value instanceof IndexedRecord)) {
                throw ExceptionsKt.BadDecodedValueError((Decoder)this, value, descriptor.getKind(), Reflection.getOrCreateKotlinClass(IndexedRecord.class), new KClass[0]);
            }
            compositeDecoder = (CompositeDecoder)new RecordGenericDecoder((IndexedRecord)value, descriptor, this.getAvro$core());
        } else if (serialKind instanceof PolymorphicKind) {
            PolymorphicGenericDecoder polymorphicGenericDecoder;
            Object value = this.decodeValue();
            if (value instanceof GenericContainer) {
                Avro avro = this.getAvro$core();
                Schema schema = ((GenericContainer)value).getSchema();
                Intrinsics.checkNotNullExpressionValue((Object)schema, (String)"getSchema(...)");
                polymorphicGenericDecoder = new PolymorphicGenericDecoder(avro, descriptor, schema, value);
            } else {
                polymorphicGenericDecoder = new PolymorphicGenericDecoder(this.getAvro$core(), descriptor, this.getCurrentWriterSchema(), value);
            }
            compositeDecoder = (CompositeDecoder)polymorphicGenericDecoder;
        } else {
            throw new SerializationException("Unsupported descriptor for structure decoding: " + descriptor);
        }
        return compositeDecoder;
    }

    public boolean decodeBoolean() {
        boolean bl;
        Object value = this.decodeValue();
        if (value instanceof Boolean) {
            bl = (Boolean)value;
        } else if (value instanceof CharSequence) {
            bl = Boolean.parseBoolean(value.toString());
        } else {
            KClass[] kClassArray = new KClass[]{Reflection.getOrCreateKotlinClass(Integer.TYPE), Reflection.getOrCreateKotlinClass(CharSequence.class)};
            throw ExceptionsKt.BadDecodedValueError((Decoder)this, value, (SerialKind)PrimitiveKind.BOOLEAN.INSTANCE, Reflection.getOrCreateKotlinClass(Boolean.TYPE), kClassArray);
        }
        return bl;
    }

    public byte decodeByte() {
        byte by;
        Object value = this.decodeValue();
        if (value instanceof Integer) {
            by = NumberUtilsKt.toByteExact(((Number)value).intValue());
        } else if (value instanceof Long) {
            by = NumberUtilsKt.toByteExact(((Number)value).longValue());
        } else if (value instanceof BigDecimal) {
            by = NumberUtilsKt.toByteExact((BigDecimal)value);
        } else if (value instanceof CharSequence) {
            by = Byte.parseByte(value.toString());
        } else {
            KClass[] kClassArray = new KClass[]{Reflection.getOrCreateKotlinClass(Long.TYPE), Reflection.getOrCreateKotlinClass(BigDecimal.class), Reflection.getOrCreateKotlinClass(CharSequence.class)};
            throw ExceptionsKt.BadDecodedValueError((Decoder)this, value, (SerialKind)PrimitiveKind.BYTE.INSTANCE, Reflection.getOrCreateKotlinClass(Integer.TYPE), kClassArray);
        }
        return by;
    }

    public short decodeShort() {
        short s;
        Object value = this.decodeValue();
        if (value instanceof Integer) {
            s = NumberUtilsKt.toShortExact(((Number)value).intValue());
        } else if (value instanceof Long) {
            s = NumberUtilsKt.toShortExact(((Number)value).longValue());
        } else if (value instanceof BigDecimal) {
            s = NumberUtilsKt.toShortExact((BigDecimal)value);
        } else if (value instanceof CharSequence) {
            s = Short.parseShort(value.toString());
        } else {
            KClass[] kClassArray = new KClass[]{Reflection.getOrCreateKotlinClass(Long.TYPE), Reflection.getOrCreateKotlinClass(BigDecimal.class), Reflection.getOrCreateKotlinClass(CharSequence.class)};
            throw ExceptionsKt.BadDecodedValueError((Decoder)this, value, (SerialKind)PrimitiveKind.SHORT.INSTANCE, Reflection.getOrCreateKotlinClass(Integer.TYPE), kClassArray);
        }
        return s;
    }

    public int decodeInt() {
        int n;
        Object value = this.decodeValue();
        if (value instanceof Integer) {
            n = ((Number)value).intValue();
        } else if (value instanceof Long) {
            n = NumberUtilsKt.toIntExact(((Number)value).longValue());
        } else if (value instanceof BigDecimal) {
            n = NumberUtilsKt.toIntExact((BigDecimal)value);
        } else if (value instanceof CharSequence) {
            n = Integer.parseInt(value.toString());
        } else {
            KClass[] kClassArray = new KClass[]{Reflection.getOrCreateKotlinClass(Long.TYPE), Reflection.getOrCreateKotlinClass(BigDecimal.class), Reflection.getOrCreateKotlinClass(CharSequence.class)};
            throw ExceptionsKt.BadDecodedValueError((Decoder)this, value, (SerialKind)PrimitiveKind.INT.INSTANCE, Reflection.getOrCreateKotlinClass(Integer.TYPE), kClassArray);
        }
        return n;
    }

    public long decodeLong() {
        long l;
        Object value = this.decodeValue();
        if (value instanceof Long) {
            l = ((Number)value).longValue();
        } else if (value instanceof Integer) {
            l = ((Number)value).intValue();
        } else if (value instanceof BigDecimal) {
            l = NumberUtilsKt.toLongExact((BigDecimal)value);
        } else if (value instanceof CharSequence) {
            l = Long.parseLong(value.toString());
        } else {
            KClass[] kClassArray = new KClass[]{Reflection.getOrCreateKotlinClass(Long.TYPE), Reflection.getOrCreateKotlinClass(BigDecimal.class), Reflection.getOrCreateKotlinClass(CharSequence.class)};
            throw ExceptionsKt.BadDecodedValueError((Decoder)this, value, (SerialKind)PrimitiveKind.LONG.INSTANCE, Reflection.getOrCreateKotlinClass(Integer.TYPE), kClassArray);
        }
        return l;
    }

    public float decodeFloat() {
        float f;
        Object value = this.decodeValue();
        if (value instanceof Float) {
            f = ((Number)value).floatValue();
        } else if (value instanceof Double) {
            f = NumberUtilsKt.toFloatExact(((Number)value).doubleValue());
        } else if (value instanceof BigDecimal) {
            f = NumberUtilsKt.toFloatExact((BigDecimal)value);
        } else if (value instanceof CharSequence) {
            f = Float.parseFloat(value.toString());
        } else {
            KClass[] kClassArray = new KClass[]{Reflection.getOrCreateKotlinClass(Double.TYPE), Reflection.getOrCreateKotlinClass(BigDecimal.class), Reflection.getOrCreateKotlinClass(CharSequence.class)};
            throw ExceptionsKt.BadDecodedValueError((Decoder)this, value, (SerialKind)PrimitiveKind.FLOAT.INSTANCE, Reflection.getOrCreateKotlinClass(Float.TYPE), kClassArray);
        }
        return f;
    }

    public double decodeDouble() {
        double d;
        Object value = this.decodeValue();
        if (value instanceof Double) {
            d = ((Number)value).doubleValue();
        } else if (value instanceof Float) {
            d = ((Number)value).floatValue();
        } else if (value instanceof BigDecimal) {
            d = NumberUtilsKt.toDoubleExact((BigDecimal)value);
        } else if (value instanceof CharSequence) {
            d = Double.parseDouble(value.toString());
        } else {
            KClass[] kClassArray = new KClass[]{Reflection.getOrCreateKotlinClass(Double.TYPE), Reflection.getOrCreateKotlinClass(BigDecimal.class), Reflection.getOrCreateKotlinClass(CharSequence.class)};
            throw ExceptionsKt.BadDecodedValueError((Decoder)this, value, (SerialKind)PrimitiveKind.DOUBLE.INSTANCE, Reflection.getOrCreateKotlinClass(Float.TYPE), kClassArray);
        }
        return d;
    }

    public char decodeChar() {
        char c;
        Object value = this.decodeValue();
        if (value instanceof Integer) {
            c = (char)((Number)value).intValue();
        } else if (value instanceof CharSequence) {
            c = StringsKt.single((CharSequence)((CharSequence)value));
        } else {
            KClass[] kClassArray = new KClass[]{Reflection.getOrCreateKotlinClass(CharSequence.class)};
            throw ExceptionsKt.BadDecodedValueError((Decoder)this, value, (SerialKind)PrimitiveKind.CHAR.INSTANCE, Reflection.getOrCreateKotlinClass(Integer.TYPE), kClassArray);
        }
        return c;
    }

    @NotNull
    public String decodeString() {
        String string;
        Object value = this.decodeValue();
        if (value instanceof CharSequence) {
            string = value.toString();
        } else if (value instanceof byte[]) {
            string = StringsKt.decodeToString((byte[])((byte[])value));
        } else if (value instanceof GenericFixed) {
            byte[] byArray = ((GenericFixed)value).bytes();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"bytes(...)");
            string = StringsKt.decodeToString((byte[])byArray);
        } else {
            KClass[] kClassArray = new KClass[]{Reflection.getOrCreateKotlinClass(byte[].class), Reflection.getOrCreateKotlinClass(GenericFixed.class)};
            throw ExceptionsKt.BadDecodedValueError((Decoder)this, value, (SerialKind)PrimitiveKind.STRING.INSTANCE, Reflection.getOrCreateKotlinClass(CharSequence.class), kClassArray);
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int decodeEnum(@NotNull SerialDescriptor enumDescriptor) {
        Intrinsics.checkNotNullParameter((Object)enumDescriptor, (String)"enumDescriptor");
        Object value = this.decodeValue();
        if (value instanceof GenericEnumSymbol || value instanceof CharSequence) {
            int n;
            Integer n2 = enumDescriptor.getElementIndex(value.toString());
            int it = ((Number)n2).intValue();
            boolean bl = false;
            Integer n3 = it >= 0 ? n2 : null;
            if (n3 != null) {
                n = n3;
                return n;
            } else {
                Integer n4 = this.getAvro$core().getEnumResolver$core().getDefaultValueIndex(enumDescriptor);
                if (n4 == null) throw new SerializationException("Unknown enum symbol '" + value + "' for Enum '" + enumDescriptor.getSerialName() + '\'');
                n = n4;
            }
            return n;
        } else {
            KClass[] kClassArray = new KClass[]{Reflection.getOrCreateKotlinClass(CharSequence.class)};
            throw ExceptionsKt.BadDecodedValueError((Decoder)this, value, (SerialKind)SerialKind.ENUM.INSTANCE, Reflection.getOrCreateKotlinClass(GenericEnumSymbol.class), kClassArray);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public byte[] decodeBytes() {
        byte[] byArray;
        Object value = this.decodeValue();
        if (value instanceof byte[]) {
            byArray = (byte[])value;
        } else if (value instanceof ByteBuffer) {
            byte[] byArray2 = ((ByteBuffer)value).array();
            byArray = byArray2;
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"array(...)");
        } else if (value instanceof GenericFixed) {
            byte[] byArray3 = ((GenericFixed)value).bytes();
            byArray = byArray3;
            Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"bytes(...)");
        } else if (value instanceof CharSequence) {
            String string = value.toString();
            byte[] byArray4 = string.getBytes(Charsets.UTF_8);
            byArray = byArray4;
            Intrinsics.checkNotNullExpressionValue((Object)byArray4, (String)"getBytes(...)");
        } else {
            void value$iv;
            void firstExpectedType$iv;
            Decoder decoder = this;
            Object object = value;
            KClass kClass = Reflection.getOrCreateKotlinClass(byte[].class);
            Object[] objectArray = new KClass[]{Reflection.getOrCreateKotlinClass(GenericFixed.class), Reflection.getOrCreateKotlinClass(CharSequence.class)};
            Object[] expectedTypes$iv = objectArray;
            boolean $i$f$BadDecodedValueError = false;
            List allExpectedTypes$iv = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)firstExpectedType$iv), (Object[])expectedTypes$iv);
            throw value$iv == null ? new SerializationException("Decoded null value for " + Reflection.getOrCreateKotlinClass(byte[].class).getQualifiedName() + " kind, expected one of [" + CollectionsKt.joinToString$default((Iterable)allExpectedTypes$iv, null, null, null, (int)0, null, (Function1)ExceptionsKt.BadDecodedValueError.1.INSTANCE, (int)31, null) + ']') : new SerializationException("Decoded value '" + value$iv + "' of type " + Reflection.getOrCreateKotlinClass(value$iv.getClass()).getQualifiedName() + " for " + Reflection.getOrCreateKotlinClass(byte[].class).getQualifiedName() + " kind, expected one of [" + CollectionsKt.joinToString$default((Iterable)allExpectedTypes$iv, null, null, null, (int)0, null, (Function1)ExceptionsKt.BadDecodedValueError.2.INSTANCE, (int)31, null) + ']');
        }
        return byArray;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public GenericFixed decodeFixed() {
        Object value = this.decodeValue();
        if (!(value instanceof GenericFixed)) {
            void value$iv;
            void firstExpectedType$iv;
            Decoder decoder = this;
            Object object = value;
            KClass kClass = Reflection.getOrCreateKotlinClass(GenericFixed.class);
            Object[] expectedTypes$iv = new KClass[]{};
            boolean $i$f$BadDecodedValueError = false;
            List allExpectedTypes$iv = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)firstExpectedType$iv), (Object[])expectedTypes$iv);
            throw value$iv == null ? new SerializationException("Decoded null value for " + Reflection.getOrCreateKotlinClass(GenericFixed.class).getQualifiedName() + " kind, expected one of [" + CollectionsKt.joinToString$default((Iterable)allExpectedTypes$iv, null, null, null, (int)0, null, (Function1)ExceptionsKt.BadDecodedValueError.1.INSTANCE, (int)31, null) + ']') : new SerializationException("Decoded value '" + value$iv + "' of type " + Reflection.getOrCreateKotlinClass(value$iv.getClass()).getQualifiedName() + " for " + Reflection.getOrCreateKotlinClass(GenericFixed.class).getQualifiedName() + " kind, expected one of [" + CollectionsKt.joinToString$default((Iterable)allExpectedTypes$iv, null, null, null, (int)0, null, (Function1)ExceptionsKt.BadDecodedValueError.2.INSTANCE, (int)31, null) + ']');
        }
        return (GenericFixed)value;
    }
}

