/*
 * Decompiled with CFR 0.152.
 */
package com.github.avrokotlin.avro4k.internal.decoder.generic;

import com.github.avrokotlin.avro4k.Avro;
import com.github.avrokotlin.avro4k.internal.DecodingStep;
import com.github.avrokotlin.avro4k.internal.ExceptionsKt;
import com.github.avrokotlin.avro4k.internal.RecordResolver;
import com.github.avrokotlin.avro4k.internal.SerializationWorkflow;
import com.github.avrokotlin.avro4k.internal.decoder.generic.AbstractAvroGenericDecoder;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.Decoder;
import org.apache.avro.Schema;
import org.apache.avro.generic.IndexedRecord;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\n\u0010\u001a\u001a\u0004\u0018\u00010\u0019H\u0002J\u0010\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u0004\u001a\u00020\u0005H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001c"}, d2={"Lcom/github/avrokotlin/avro4k/internal/decoder/generic/RecordGenericDecoder;", "Lcom/github/avrokotlin/avro4k/internal/decoder/generic/AbstractAvroGenericDecoder;", "record", "Lorg/apache/avro/generic/IndexedRecord;", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "avro", "Lcom/github/avrokotlin/avro4k/Avro;", "<init>", "(Lorg/apache/avro/generic/IndexedRecord;Lkotlinx/serialization/descriptors/SerialDescriptor;Lcom/github/avrokotlin/avro4k/Avro;)V", "getAvro$core", "()Lcom/github/avrokotlin/avro4k/Avro;", "classDescriptor", "Lcom/github/avrokotlin/avro4k/internal/SerializationWorkflow;", "currentElement", "Lcom/github/avrokotlin/avro4k/internal/DecodingStep$ValidatedDecodingStep;", "nextDecodingStep", "", "currentWriterSchema", "Lorg/apache/avro/Schema;", "getCurrentWriterSchema", "()Lorg/apache/avro/Schema;", "decodeNotNullMark", "", "decodeValue", "", "decodeNullableValue", "decodeElementIndex", "core"})
public final class RecordGenericDecoder
extends AbstractAvroGenericDecoder {
    @NotNull
    private final IndexedRecord record;
    @NotNull
    private final SerialDescriptor descriptor;
    @NotNull
    private final Avro avro;
    @NotNull
    private final SerializationWorkflow classDescriptor;
    private DecodingStep.ValidatedDecodingStep currentElement;
    private int nextDecodingStep;

    public RecordGenericDecoder(@NotNull IndexedRecord record, @NotNull SerialDescriptor descriptor, @NotNull Avro avro) {
        Intrinsics.checkNotNullParameter((Object)record, (String)"record");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)avro, (String)"avro");
        this.record = record;
        this.descriptor = descriptor;
        this.avro = avro;
        RecordResolver recordResolver = this.getAvro$core().getRecordResolver$core();
        Schema schema = this.record.getSchema();
        Intrinsics.checkNotNullExpressionValue((Object)schema, (String)"getSchema(...)");
        this.classDescriptor = recordResolver.resolveFields(schema, this.descriptor);
    }

    @Override
    @NotNull
    public Avro getAvro$core() {
        return this.avro;
    }

    @Override
    @NotNull
    public Schema getCurrentWriterSchema() {
        DecodingStep.ValidatedDecodingStep validatedDecodingStep = this.currentElement;
        if (validatedDecodingStep == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentElement");
            validatedDecodingStep = null;
        }
        return validatedDecodingStep.getSchema();
    }

    @Override
    public boolean decodeNotNullMark() {
        return this.decodeNullableValue() != null;
    }

    @Override
    @NotNull
    public Object decodeValue() {
        Object object = this.decodeNullableValue();
        if (object == null) {
            Decoder decoder = this;
            DecodingStep.ValidatedDecodingStep validatedDecodingStep = this.currentElement;
            if (validatedDecodingStep == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"currentElement");
                validatedDecodingStep = null;
            }
            throw ExceptionsKt.DecodedNullError(decoder, this.descriptor, validatedDecodingStep.getElementIndex());
        }
        return object;
    }

    private final Object decodeNullableValue() {
        Object object;
        DecodingStep.ValidatedDecodingStep element;
        DecodingStep.ValidatedDecodingStep validatedDecodingStep = this.currentElement;
        if (validatedDecodingStep == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentElement");
            validatedDecodingStep = null;
        }
        if ((element = validatedDecodingStep) instanceof DecodingStep.DeserializeWriterField) {
            object = this.record.get(((DecodingStep.DeserializeWriterField)element).getWriterFieldIndex());
        } else if (element instanceof DecodingStep.GetDefaultValue) {
            object = ((DecodingStep.GetDefaultValue)element).getDefaultValue();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return object;
    }

    public int decodeElementIndex(@NotNull SerialDescriptor descriptor) {
        int n;
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        DecodingStep field = null;
        do {
            if (this.nextDecodingStep == this.classDescriptor.getDecoding().length) {
                return -1;
            }
            n = this.nextDecodingStep;
            this.nextDecodingStep = n + 1;
        } while (!((field = this.classDescriptor.getDecoding()[n]) instanceof DecodingStep.ValidatedDecodingStep));
        this.currentElement = (DecodingStep.ValidatedDecodingStep)field;
        return ((DecodingStep.ValidatedDecodingStep)field).getElementIndex();
    }
}

