/*
 * Decompiled with CFR 0.152.
 */
package com.github.avrokotlin.avro4k.internal.encoder.generic;

import com.github.avrokotlin.avro4k.Avro;
import com.github.avrokotlin.avro4k.internal.encoder.generic.AbstractAvroGenericEncoder;
import com.github.avrokotlin.avro4k.internal.encoder.generic.MapGenericEncoderKt;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.descriptors.SerialDescriptor;
import org.apache.avro.Schema;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012 \u0010\b\u001a\u001c\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\f0\n\u0012\u0004\u0012\u00020\r0\t\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0005H\u0016J\u0010\u0010 \u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010!\u001a\u00020\r2\u0006\u0010\"\u001a\u00020\fH\u0016J\b\u0010#\u001a\u00020\rH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\b\u001a\u001c\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\f0\n\u0012\u0004\u0012\u00020\r0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0012\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\f0\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\u00020\u0007X\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001a\u00a8\u0006$"}, d2={"Lcom/github/avrokotlin/avro4k/internal/encoder/generic/MapGenericEncoder;", "Lcom/github/avrokotlin/avro4k/internal/encoder/generic/AbstractAvroGenericEncoder;", "avro", "Lcom/github/avrokotlin/avro4k/Avro;", "mapSize", "", "schema", "Lorg/apache/avro/Schema;", "onEncoded", "Lkotlin/Function1;", "", "", "", "", "<init>", "(Lcom/github/avrokotlin/avro4k/Avro;ILorg/apache/avro/Schema;Lkotlin/jvm/functions/Function1;)V", "getAvro", "()Lcom/github/avrokotlin/avro4k/Avro;", "entries", "", "Lkotlin/Pair;", "currentKey", "currentWriterSchema", "getCurrentWriterSchema", "()Lorg/apache/avro/Schema;", "setCurrentWriterSchema", "(Lorg/apache/avro/Schema;)V", "encodeElement", "", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "index", "endStructure", "encodeValue", "value", "encodeNullUnchecked", "core"})
@SourceDebugExtension(value={"SMAP\nMapGenericEncoder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MapGenericEncoder.kt\ncom/github/avrokotlin/avro4k/internal/encoder/generic/MapGenericEncoder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,53:1\n1193#2,2:54\n1267#2,4:56\n*S KotlinDebug\n*F\n+ 1 MapGenericEncoder.kt\ncom/github/avrokotlin/avro4k/internal/encoder/generic/MapGenericEncoder\n*L\n37#1:54,2\n37#1:56,4\n*E\n"})
public final class MapGenericEncoder
extends AbstractAvroGenericEncoder {
    @NotNull
    private final Avro avro;
    @NotNull
    private final Schema schema;
    @NotNull
    private final Function1<Map<String, ? extends Object>, Unit> onEncoded;
    @NotNull
    private final List<Pair<String, Object>> entries;
    @Nullable
    private String currentKey;
    public Schema currentWriterSchema;

    public MapGenericEncoder(@NotNull Avro avro, int mapSize, @NotNull Schema schema, @NotNull Function1<? super Map<String, ? extends Object>, Unit> onEncoded) {
        Intrinsics.checkNotNullParameter((Object)avro, (String)"avro");
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        Intrinsics.checkNotNullParameter(onEncoded, (String)"onEncoded");
        this.avro = avro;
        this.schema = schema;
        this.onEncoded = onEncoded;
        this.entries = new ArrayList(mapSize);
    }

    @Override
    @NotNull
    public Avro getAvro() {
        return this.avro;
    }

    @Override
    @NotNull
    public Schema getCurrentWriterSchema() {
        Schema schema = this.currentWriterSchema;
        if (schema != null) {
            return schema;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"currentWriterSchema");
        return null;
    }

    @Override
    public void setCurrentWriterSchema(@NotNull Schema schema) {
        Intrinsics.checkNotNullParameter((Object)schema, (String)"<set-?>");
        this.currentWriterSchema = schema;
    }

    @Override
    public boolean encodeElement(@NotNull SerialDescriptor descriptor, int index) {
        Schema schema;
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        super.encodeElement(descriptor, index);
        if (index % 2 == 0) {
            this.currentKey = null;
            schema = MapGenericEncoderKt.access$getSTRING_SCHEMA$p();
        } else {
            schema = this.schema.getValueType();
        }
        Schema schema2 = schema;
        Intrinsics.checkNotNull((Object)schema2);
        this.setCurrentWriterSchema(schema2);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public void endStructure(@NotNull SerialDescriptor descriptor) {
        void $this$associateTo$iv$iv;
        void $this$associate$iv;
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Iterable iterable = this.entries;
        Function1<Map<String, ? extends Object>, Unit> function1 = this.onEncoded;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        void var5_6 = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            Pair it = (Pair)element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)it.getFirst(), (Object)it.getSecond());
            map.put(pair.getFirst(), pair.getSecond());
        }
        function1.invoke((Object)destination$iv$iv);
    }

    @Override
    public void encodeValue(@NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String key = this.currentKey;
        if (key == null) {
            this.currentKey = value.toString();
        } else {
            this.entries.add((Pair<String, Object>)TuplesKt.to((Object)key, (Object)value));
        }
    }

    @Override
    public void encodeNullUnchecked() {
        String string = this.currentKey;
        if (string == null) {
            throw new SerializationException("Map key cannot be null");
        }
        String key = string;
        this.entries.add((Pair<String, Object>)TuplesKt.to((Object)key, null));
    }
}

