/*
 * Decompiled with CFR 0.152.
 */
package com.github.avrokotlin.avro4k.internal.schema;

import com.github.avrokotlin.avro4k.internal.AvroSchemaGenerationException;
import com.github.avrokotlin.avro4k.internal.schema.MapVisitorKt;
import com.github.avrokotlin.avro4k.internal.schema.SerialDescriptorMapVisitor;
import com.github.avrokotlin.avro4k.internal.schema.ValueVisitor;
import com.github.avrokotlin.avro4k.internal.schema.VisitorContext;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.descriptors.SerialDescriptor;
import org.apache.avro.Schema;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0010H\u0016J\u0010\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/github/avrokotlin/avro4k/internal/schema/MapVisitor;", "Lcom/github/avrokotlin/avro4k/internal/schema/SerialDescriptorMapVisitor;", "context", "Lcom/github/avrokotlin/avro4k/internal/schema/VisitorContext;", "onSchemaBuilt", "Lkotlin/Function1;", "Lorg/apache/avro/Schema;", "", "<init>", "(Lcom/github/avrokotlin/avro4k/internal/schema/VisitorContext;Lkotlin/jvm/functions/Function1;)V", "valueSchema", "visitMapKey", "Lcom/github/avrokotlin/avro4k/internal/schema/ValueVisitor;", "mapDescriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "keyElementIndex", "", "visitMapValue", "valueElementIndex", "endMapVisit", "descriptor", "core"})
public final class MapVisitor
implements SerialDescriptorMapVisitor {
    @NotNull
    private final VisitorContext context;
    @NotNull
    private final Function1<Schema, Unit> onSchemaBuilt;
    private Schema valueSchema;

    public MapVisitor(@NotNull VisitorContext context, @NotNull Function1<? super Schema, Unit> onSchemaBuilt) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(onSchemaBuilt, (String)"onSchemaBuilt");
        this.context = context;
        this.onSchemaBuilt = onSchemaBuilt;
    }

    @Override
    @NotNull
    public ValueVisitor visitMapKey(@NotNull SerialDescriptor mapDescriptor, int keyElementIndex) {
        Intrinsics.checkNotNullParameter((Object)mapDescriptor, (String)"mapDescriptor");
        return new ValueVisitor(this.context, (Function1<? super Schema, Unit>)((Function1)MapVisitor::visitMapKey$lambda$0));
    }

    @Override
    @NotNull
    public ValueVisitor visitMapValue(@NotNull SerialDescriptor mapDescriptor, int valueElementIndex) {
        Intrinsics.checkNotNullParameter((Object)mapDescriptor, (String)"mapDescriptor");
        return new ValueVisitor(this.context, (Function1<? super Schema, Unit>)((Function1)arg_0 -> MapVisitor.visitMapValue$lambda$0(this, arg_0)));
    }

    @Override
    public void endMapVisit(@NotNull SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Schema schema = this.valueSchema;
        if (schema == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"valueSchema");
            schema = null;
        }
        Schema schema2 = Schema.createMap((Schema)schema);
        Intrinsics.checkNotNullExpressionValue((Object)schema2, (String)"createMap(...)");
        this.onSchemaBuilt.invoke((Object)schema2);
    }

    private static final Unit visitMapKey$lambda$0(Schema it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (it.isNullable()) {
            throw new AvroSchemaGenerationException("Map key cannot be nullable. Actual generated map key schema: " + it);
        }
        if (!MapVisitorKt.isNonNullScalarType(it)) {
            throw new AvroSchemaGenerationException("Map key must be a non-null scalar type (e.g. not a record, map or array). Actual generated map key schema: " + it);
        }
        return Unit.INSTANCE;
    }

    private static final Unit visitMapValue$lambda$0(MapVisitor this$0, Schema it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.valueSchema = it;
        return Unit.INSTANCE;
    }
}

