/*
 * Decompiled with CFR 0.152.
 */
package com.github.avrokotlin.avro4k.internal.schema;

import com.github.avrokotlin.avro4k.Avro;
import com.github.avrokotlin.avro4k.AvroDoc;
import com.github.avrokotlin.avro4k.AvroProp;
import com.github.avrokotlin.avro4k.internal.AvroGenerated;
import com.github.avrokotlin.avro4k.internal.HelpersKt;
import com.github.avrokotlin.avro4k.internal.SerializerLocatorMiddleware;
import com.github.avrokotlin.avro4k.internal.schema.ClassVisitor;
import com.github.avrokotlin.avro4k.internal.schema.InlineClassVisitor;
import com.github.avrokotlin.avro4k.internal.schema.ListVisitor;
import com.github.avrokotlin.avro4k.internal.schema.MapVisitor;
import com.github.avrokotlin.avro4k.internal.schema.PolymorphicVisitor;
import com.github.avrokotlin.avro4k.internal.schema.SerialDescriptorValueVisitor;
import com.github.avrokotlin.avro4k.internal.schema.TypeAnnotations;
import com.github.avrokotlin.avro4k.internal.schema.ValueVisitorKt;
import com.github.avrokotlin.avro4k.internal.schema.VisitorContext;
import com.github.avrokotlin.avro4k.serializer.AvroSchemaSupplier;
import com.github.avrokotlin.avro4k.serializer.AvroSerializerKt;
import com.github.avrokotlin.avro4k.serializer.ElementLocation;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlinx.serialization.descriptors.PolymorphicKind;
import kotlinx.serialization.descriptors.PrimitiveKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialDescriptorsKt;
import kotlinx.serialization.modules.SerializersModule;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B%\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0004\b\b\u0010\tB%\b\u0016\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0004\b\b\u0010\fJ\u0018\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010!\u001a\u00020\"2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020%2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010&\u001a\u00020'2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010(\u001a\u00020)2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010*\u001a\u00020\u00072\u0006\u0010+\u001a\u00020\u0006H\u0002J\u0010\u0010,\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010-\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u001e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a*\u00020\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006."}, d2={"Lcom/github/avrokotlin/avro4k/internal/schema/ValueVisitor;", "Lcom/github/avrokotlin/avro4k/internal/schema/SerialDescriptorValueVisitor;", "context", "Lcom/github/avrokotlin/avro4k/internal/schema/VisitorContext;", "onSchemaBuilt", "Lkotlin/Function1;", "Lorg/apache/avro/Schema;", "", "<init>", "(Lcom/github/avrokotlin/avro4k/internal/schema/VisitorContext;Lkotlin/jvm/functions/Function1;)V", "avro", "Lcom/github/avrokotlin/avro4k/Avro;", "(Lcom/github/avrokotlin/avro4k/Avro;Lkotlin/jvm/functions/Function1;)V", "isNullable", "", "serializersModule", "Lkotlinx/serialization/modules/SerializersModule;", "getSerializersModule", "()Lkotlinx/serialization/modules/SerializersModule;", "visitPrimitive", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "kind", "Lkotlinx/serialization/descriptors/PrimitiveKind;", "visitEnum", "elementNamesArray", "", "", "getElementNamesArray", "(Lkotlinx/serialization/descriptors/SerialDescriptor;)[Ljava/lang/String;", "visitObject", "visitClass", "Lcom/github/avrokotlin/avro4k/internal/schema/ClassVisitor;", "visitPolymorphic", "Lcom/github/avrokotlin/avro4k/internal/schema/PolymorphicVisitor;", "Lkotlinx/serialization/descriptors/PolymorphicKind;", "visitList", "Lcom/github/avrokotlin/avro4k/internal/schema/ListVisitor;", "visitMap", "Lcom/github/avrokotlin/avro4k/internal/schema/MapVisitor;", "visitInlineClass", "Lcom/github/avrokotlin/avro4k/internal/schema/InlineClassVisitor;", "setSchema", "schema", "visitValue", "unwrapNullable", "core"})
@SourceDebugExtension(value={"SMAP\nValueVisitor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ValueVisitor.kt\ncom/github/avrokotlin/avro4k/internal/schema/ValueVisitor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 5 helpers.kt\ncom/github/avrokotlin/avro4k/internal/HelpersKt\n+ 6 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,134:1\n1#2:135\n1#2:141\n13805#3,2:136\n1321#4,2:138\n26#5:140\n1761#6,3:142\n*S KotlinDebug\n*F\n+ 1 ValueVisitor.kt\ncom/github/avrokotlin/avro4k/internal/schema/ValueVisitor\n*L\n91#1:141\n53#1:136,2\n54#1:138,2\n91#1:140\n102#1:142,3\n*E\n"})
public final class ValueVisitor
implements SerialDescriptorValueVisitor {
    @NotNull
    private final VisitorContext context;
    @NotNull
    private final Function1<Schema, Unit> onSchemaBuilt;
    private boolean isNullable;

    public ValueVisitor(@NotNull VisitorContext context, @NotNull Function1<? super Schema, Unit> onSchemaBuilt) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(onSchemaBuilt, (String)"onSchemaBuilt");
        this.context = context;
        this.onSchemaBuilt = onSchemaBuilt;
    }

    @Override
    @NotNull
    public SerializersModule getSerializersModule() {
        return this.context.getAvro().getSerializersModule();
    }

    public ValueVisitor(@NotNull Avro avro, @NotNull Function1<? super Schema, Unit> onSchemaBuilt) {
        Intrinsics.checkNotNullParameter((Object)avro, (String)"avro");
        Intrinsics.checkNotNullParameter(onSchemaBuilt, (String)"onSchemaBuilt");
        this(new VisitorContext(avro, new LinkedHashMap(), null, 4, null), onSchemaBuilt);
    }

    @Override
    public void visitPrimitive(@NotNull SerialDescriptor descriptor, @NotNull PrimitiveKind kind) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        this.setSchema(ValueVisitorKt.access$toSchema(kind));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitEnum(@NotNull SerialDescriptor descriptor) {
        String string;
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        TypeAnnotations annotations = new TypeAnnotations(descriptor);
        AvroDoc avroDoc = annotations.getDoc();
        SchemaBuilder.EnumBuilder enumBuilder = (SchemaBuilder.EnumBuilder)SchemaBuilder.enumeration((String)HelpersKt.getNonNullSerialName(descriptor)).doc(avroDoc != null ? avroDoc.value() : null);
        Integer n = this.context.getAvro().getEnumResolver$core().getDefaultValueIndex(descriptor);
        if (n != null) {
            void it;
            int n2 = ((Number)n).intValue();
            SchemaBuilder.EnumBuilder enumBuilder2 = enumBuilder;
            boolean bl = false;
            string = descriptor.getElementName((int)it);
            enumBuilder = enumBuilder2;
        } else {
            string = null;
        }
        String[] stringArray = this.getElementNamesArray(descriptor);
        Schema schema = (Schema)enumBuilder.defaultSymbol(string).symbols(Arrays.copyOf(stringArray, stringArray.length));
        String[] stringArray2 = annotations.getAliases();
        if (stringArray2 != null && (stringArray2 = stringArray2.value()) != null) {
            String[] $this$forEach$iv = stringArray2;
            boolean $i$f$forEach = false;
            int n3 = $this$forEach$iv.length;
            for (int i = 0; i < n3; ++i) {
                String element$iv;
                String it = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                schema.addAlias(it);
            }
        }
        Sequence<AvroProp> $this$forEach$iv = annotations.getProps();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AvroProp it = (AvroProp)element$iv;
            boolean bl = false;
            schema.addProp(it.key(), (Object)HelpersKt.getJsonNode(it));
        }
        Intrinsics.checkNotNull((Object)schema);
        this.setSchema(schema);
    }

    private final String[] getElementNamesArray(SerialDescriptor $this$elementNamesArray) {
        int n = 0;
        int n2 = $this$elementNamesArray.getElementsCount();
        String[] stringArray = new String[n2];
        while (n < n2) {
            int n3 = n++;
            stringArray[n3] = $this$elementNamesArray.getElementName(n3);
        }
        return stringArray;
    }

    @Override
    public void visitObject(@NotNull SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        this.visitClass(descriptor).endClassVisit(descriptor);
    }

    @Override
    @NotNull
    public ClassVisitor visitClass(@NotNull SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        return new ClassVisitor(descriptor, VisitorContext.copy$default(this.context, null, null, CollectionsKt.emptyList(), 3, null), (Function1<? super Schema, Unit>)((Function1)arg_0 -> ValueVisitor.visitClass$lambda$0(this, arg_0)));
    }

    @Override
    @NotNull
    public PolymorphicVisitor visitPolymorphic(@NotNull SerialDescriptor descriptor, @NotNull PolymorphicKind kind) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        return new PolymorphicVisitor(this.context, (Function1<? super Schema, Unit>)((Function1)arg_0 -> ValueVisitor.visitPolymorphic$lambda$0(this, arg_0)));
    }

    @Override
    @NotNull
    public ListVisitor visitList(@NotNull SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        return new ListVisitor(VisitorContext.copy$default(this.context, null, null, CollectionsKt.emptyList(), 3, null), (Function1<? super Schema, Unit>)((Function1)arg_0 -> ValueVisitor.visitList$lambda$0(this, arg_0)));
    }

    @Override
    @NotNull
    public MapVisitor visitMap(@NotNull SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        return new MapVisitor(VisitorContext.copy$default(this.context, null, null, CollectionsKt.emptyList(), 3, null), (Function1<? super Schema, Unit>)((Function1)arg_0 -> ValueVisitor.visitMap$lambda$0(this, arg_0)));
    }

    @Override
    @NotNull
    public InlineClassVisitor visitInlineClass(@NotNull SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        return new InlineClassVisitor(this.context, (Function1<? super Schema, Unit>)((Function1)arg_0 -> ValueVisitor.visitInlineClass$lambda$0(this, arg_0)));
    }

    private final void setSchema(Schema schema) {
        if (this.isNullable && !schema.isNullable()) {
            this.onSchemaBuilt.invoke((Object)HelpersKt.getNullable(schema));
        } else {
            this.onSchemaBuilt.invoke((Object)schema);
        }
    }

    @Override
    public void visitValue(@NotNull SerialDescriptor descriptor) {
        boolean bl;
        SerialDescriptor finalDescriptor;
        block9: {
            AvroGenerated avroGenerated;
            Annotation annotation;
            block8: {
                Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
                finalDescriptor = SerializerLocatorMiddleware.INSTANCE.apply(this.unwrapNullable(descriptor));
                SerialDescriptor $this$findAnnotation$iv = descriptor;
                boolean $i$f$findAnnotation = false;
                for (Annotation it$iv : (Iterable)$this$findAnnotation$iv.getAnnotations()) {
                    boolean bl2 = false;
                    Annotation annotation2 = it$iv;
                    if (!(annotation2 instanceof AvroGenerated)) {
                        annotation2 = null;
                    }
                    if ((it$iv = (Annotation)((AvroGenerated)annotation2)) == null) continue;
                    annotation = it$iv;
                    break block8;
                }
                annotation = null;
            }
            if ((avroGenerated = (AvroGenerated)annotation) != null) {
                AvroGenerated it = avroGenerated;
                boolean bl3 = false;
                Schema schema = new Schema.Parser().parse(it.originalSchema());
                Intrinsics.checkNotNullExpressionValue((Object)schema, (String)"parse(...)");
                this.setSchema(schema);
                return;
            }
            if (finalDescriptor instanceof AvroSchemaSupplier) {
                this.setSchema(((AvroSchemaSupplier)finalDescriptor).getSchema(this.context));
                return;
            }
            Iterable $this$any$iv = this.context.getInlinedElements();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ElementLocation it = (ElementLocation)element$iv;
                    boolean bl4 = false;
                    if (!(AvroSerializerKt.getStringable(it) != null)) continue;
                    bl = true;
                    break block9;
                }
                bl = false;
            }
        }
        if (bl) {
            Schema schema = Schema.create((Schema.Type)Schema.Type.STRING);
            Intrinsics.checkNotNullExpressionValue((Object)schema, (String)"create(...)");
            this.setSchema(schema);
            return;
        }
        SerialDescriptorValueVisitor.super.visitValue(finalDescriptor);
    }

    private final SerialDescriptor unwrapNullable(SerialDescriptor descriptor) {
        if (descriptor.isNullable()) {
            this.isNullable = true;
            return SerialDescriptorsKt.getNonNullOriginal((SerialDescriptor)descriptor);
        }
        return descriptor;
    }

    private static final Unit visitClass$lambda$0(ValueVisitor this$0, Schema it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.setSchema(it);
        return Unit.INSTANCE;
    }

    private static final Unit visitPolymorphic$lambda$0(ValueVisitor this$0, Schema it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.setSchema(it);
        return Unit.INSTANCE;
    }

    private static final Unit visitList$lambda$0(ValueVisitor this$0, Schema it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.setSchema(it);
        return Unit.INSTANCE;
    }

    private static final Unit visitMap$lambda$0(ValueVisitor this$0, Schema it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.setSchema(it);
        return Unit.INSTANCE;
    }

    private static final Unit visitInlineClass$lambda$0(ValueVisitor this$0, Schema it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.setSchema(it);
        return Unit.INSTANCE;
    }
}

