/*
 * Decompiled with CFR 0.152.
 */
package com.github.avrokotlin.avro4k.serializer;

import com.github.avrokotlin.avro4k.AnyValueDecoder;
import com.github.avrokotlin.avro4k.AvroDecoder;
import com.github.avrokotlin.avro4k.AvroEncoder;
import com.github.avrokotlin.avro4k.AvroEncoderKt;
import com.github.avrokotlin.avro4k.AvroStringable;
import com.github.avrokotlin.avro4k.internal.ExceptionsKt;
import com.github.avrokotlin.avro4k.internal.HelpersKt;
import com.github.avrokotlin.avro4k.internal.decoder.direct.AbstractAvroDirectDecoder;
import com.github.avrokotlin.avro4k.serializer.AvroSerializer;
import com.github.avrokotlin.avro4k.serializer.AvroSerializerKt;
import com.github.avrokotlin.avro4k.serializer.ElementLocation;
import com.github.avrokotlin.avro4k.serializer.SchemaSupplierContext;
import java.time.LocalTime;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.encoding.Decoder;
import kotlinx.serialization.encoding.Encoder;
import org.apache.avro.LogicalType;
import org.apache.avro.Schema;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u0018\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\u0002H\u0016J\f\u0010\u0010\u001a\u00020\u0011*\u00020\u0002H\u0002J\f\u0010\u0012\u001a\u00020\u0013*\u00020\u0002H\u0002J\u0010\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u0018H\u0016\u00a8\u0006\u0019"}, d2={"Lcom/github/avrokotlin/avro4k/serializer/LocalTimeSerializer;", "Lcom/github/avrokotlin/avro4k/serializer/AvroSerializer;", "Ljava/time/LocalTime;", "<init>", "()V", "getSchema", "Lorg/apache/avro/Schema;", "context", "Lcom/github/avrokotlin/avro4k/serializer/SchemaSupplierContext;", "serializeAvro", "", "encoder", "Lcom/github/avrokotlin/avro4k/AvroEncoder;", "value", "serializeGeneric", "Lkotlinx/serialization/encoding/Encoder;", "toMillisOfDay", "", "toMicroOfDay", "", "deserializeAvro", "decoder", "Lcom/github/avrokotlin/avro4k/AvroDecoder;", "deserializeGeneric", "Lkotlinx/serialization/encoding/Decoder;", "core"})
@SourceDebugExtension(value={"SMAP\nJavaTimeSerializers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavaTimeSerializers.kt\ncom/github/avrokotlin/avro4k/serializer/LocalTimeSerializer\n+ 2 AvroDecoder.kt\ncom/github/avrokotlin/avro4k/AvroDecoderKt\n*L\n1#1,545:1\n104#2:546\n297#2,13:547\n*S KotlinDebug\n*F\n+ 1 JavaTimeSerializers.kt\ncom/github/avrokotlin/avro4k/serializer/LocalTimeSerializer\n*L\n175#1:546\n175#1:547,13\n*E\n"})
public final class LocalTimeSerializer
extends AvroSerializer<LocalTime> {
    @NotNull
    public static final LocalTimeSerializer INSTANCE = new LocalTimeSerializer();

    private LocalTimeSerializer() {
        String string = Reflection.getOrCreateKotlinClass(LocalTime.class).getQualifiedName();
        Intrinsics.checkNotNull((Object)string);
        super(string);
    }

    @Override
    @NotNull
    public Schema getSchema(@NotNull SchemaSupplierContext context) {
        Schema schema;
        Schema schema2;
        block2: {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            for (ElementLocation it : (Iterable)context.getInlinedElements()) {
                boolean bl = false;
                AvroStringable avroStringable = AvroSerializerKt.getStringable(it);
                Object object = avroStringable != null ? AvroSerializerKt.createSchema(avroStringable) : null;
                if (object == null) continue;
                schema2 = object;
                break block2;
            }
            schema2 = schema = null;
        }
        if (schema2 == null) {
            Schema schema3 = Schema.create((Schema.Type)Schema.Type.INT);
            Intrinsics.checkNotNullExpressionValue((Object)schema3, (String)"create(...)");
            schema = HelpersKt.copy$default(schema3, null, null, null, null, false, null, null, null, null, 0, null, null, null, null, new LogicalType("time-millis"), null, 49151, null);
        }
        return schema;
    }

    @Override
    public void serializeAvro(@NotNull AvroEncoder encoder, @NotNull LocalTime value) {
        Intrinsics.checkNotNullParameter((Object)encoder, (String)"encoder");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        AvroEncoder $this$serializeAvro_u24lambda_u240 = encoder;
        boolean bl = false;
        if ($this$serializeAvro_u24lambda_u240.getCurrentWriterSchema().isUnion() && !AvroEncoderKt.trySelectTypeNameFromUnion($this$serializeAvro_u24lambda_u240, Schema.Type.INT) && !AvroEncoderKt.trySelectTypeNameFromUnion($this$serializeAvro_u24lambda_u240, Schema.Type.LONG) && !AvroEncoderKt.trySelectTypeNameFromUnion($this$serializeAvro_u24lambda_u240, Schema.Type.STRING)) {
            Schema.Type[] typeArray = new Schema.Type[]{Schema.Type.LONG, Schema.Type.STRING};
            throw AvroEncoderKt.unsupportedWriterTypeError($this$serializeAvro_u24lambda_u240, Schema.Type.INT, typeArray);
        }
        Schema.Type type = $this$serializeAvro_u24lambda_u240.getCurrentWriterSchema().getType();
        switch (type == null ? -1 : WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: {
                LogicalType logicalType = $this$serializeAvro_u24lambda_u240.getCurrentWriterSchema().getLogicalType();
                if (Intrinsics.areEqual((Object)(logicalType != null ? logicalType.getName() : null), (Object)"time-millis")) {
                    $this$serializeAvro_u24lambda_u240.encodeInt(INSTANCE.toMillisOfDay(value));
                    break;
                }
                throw AvroEncoderKt.logicalTypeMismatchError($this$serializeAvro_u24lambda_u240, "time-millis", Schema.Type.INT);
            }
            case 2: {
                LogicalType logicalType = $this$serializeAvro_u24lambda_u240.getCurrentWriterSchema().getLogicalType();
                if (Intrinsics.areEqual((Object)(logicalType != null ? logicalType.getName() : null), (Object)"time-micros")) {
                    $this$serializeAvro_u24lambda_u240.encodeLong(INSTANCE.toMicroOfDay(value));
                    break;
                }
                throw AvroEncoderKt.logicalTypeMismatchError($this$serializeAvro_u24lambda_u240, "time-micros", Schema.Type.LONG);
            }
            case 3: {
                String string = value.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                $this$serializeAvro_u24lambda_u240.encodeString(string);
                break;
            }
            default: {
                Schema.Type[] typeArray = new Schema.Type[]{Schema.Type.LONG, Schema.Type.STRING};
                throw AvroEncoderKt.unsupportedWriterTypeError($this$serializeAvro_u24lambda_u240, Schema.Type.INT, typeArray);
            }
        }
    }

    @Override
    public void serializeGeneric(@NotNull Encoder encoder, @NotNull LocalTime value) {
        Intrinsics.checkNotNullParameter((Object)encoder, (String)"encoder");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String string = value.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        encoder.encodeString(string);
    }

    private final int toMillisOfDay(LocalTime $this$toMillisOfDay) {
        return (int)($this$toMillisOfDay.toNanoOfDay() / 1000000L);
    }

    private final long toMicroOfDay(LocalTime $this$toMicroOfDay) {
        return $this$toMicroOfDay.toNanoOfDay() / 1000L;
    }

    @Override
    @NotNull
    public LocalTime deserializeAvro(@NotNull AvroDecoder decoder) {
        AnyValueDecoder<LocalTime> foundResolver$iv$iv;
        Schema.Type[] typeArray;
        AnyValueDecoder<LocalTime> anyValueDecoder;
        AvroDecoder $this$decodeResolvingAny$iv;
        AvroDecoder $this$deserializeAvro_u24lambda_u240;
        block21: {
            Intrinsics.checkNotNullParameter((Object)decoder, (String)"decoder");
            $this$deserializeAvro_u24lambda_u240 = decoder;
            boolean bl = false;
            $this$decodeResolvingAny$iv = $this$deserializeAvro_u24lambda_u240;
            boolean $i$f$decodeResolvingAny = false;
            AvroDecoder $this$findValueDecoder$iv$iv = $this$decodeResolvingAny$iv;
            boolean $i$f$findValueDecoder = false;
            Schema schema$iv$iv = $this$findValueDecoder$iv$iv.getCurrentWriterSchema();
            if (schema$iv$iv.isUnion()) {
                if ($this$findValueDecoder$iv$iv instanceof AbstractAvroDirectDecoder) {
                    throw new UnsupportedOperationException("The union should be already resolved, which means a misusage of avro4k");
                }
                List list = $this$findValueDecoder$iv$iv.getCurrentWriterSchema().getTypes();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getTypes(...)");
                for (Schema it : (Iterable)list) {
                    AnyValueDecoder<LocalTime> anyValueDecoder2;
                    AnyValueDecoder<LocalTime> anyValueDecoder3;
                    boolean bl2 = false;
                    Schema.Type type = it.getType();
                    switch (type == null ? -1 : WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                        case 1: {
                            String string;
                            LogicalType logicalType = it.getLogicalType();
                            String string2 = string = logicalType != null ? logicalType.getName() : null;
                            if (Intrinsics.areEqual((Object)string, (Object)"time-millis") || string == null) {
                                anyValueDecoder3 = arg_0 -> LocalTimeSerializer.deserializeAvro$lambda$0$1$0(decoder, arg_0);
                                break;
                            }
                            anyValueDecoder3 = null;
                            break;
                        }
                        case 2: {
                            String string;
                            LogicalType logicalType = it.getLogicalType();
                            String string3 = string = logicalType != null ? logicalType.getName() : null;
                            if (string == null) {
                                anyValueDecoder3 = arg_0 -> LocalTimeSerializer.deserializeAvro$lambda$0$1$1(decoder, arg_0);
                                break;
                            }
                            if (Intrinsics.areEqual((Object)string, (Object)"time-micros")) {
                                anyValueDecoder3 = arg_0 -> LocalTimeSerializer.deserializeAvro$lambda$0$1$2(decoder, arg_0);
                                break;
                            }
                            anyValueDecoder3 = null;
                            break;
                        }
                        case 3: {
                            anyValueDecoder3 = arg_0 -> LocalTimeSerializer.deserializeAvro$lambda$0$1$3(decoder, arg_0);
                            break;
                        }
                        default: {
                            anyValueDecoder3 = null;
                        }
                    }
                    if ((anyValueDecoder2 = anyValueDecoder3) == null) continue;
                    anyValueDecoder = anyValueDecoder2;
                    break block21;
                }
                anyValueDecoder = null;
            } else {
                Schema it = schema$iv$iv;
                boolean bl3 = false;
                Schema.Type type = it.getType();
                switch (type == null ? -1 : WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                    case 1: {
                        LogicalType logicalType = it.getLogicalType();
                        Object object = typeArray = logicalType != null ? logicalType.getName() : null;
                        if (Intrinsics.areEqual((Object)typeArray, (Object)"time-millis") || typeArray == null) {
                            anyValueDecoder = arg_0 -> LocalTimeSerializer.deserializeAvro$lambda$0$1$0(decoder, arg_0);
                            break;
                        }
                        anyValueDecoder = null;
                        break;
                    }
                    case 2: {
                        LogicalType logicalType = it.getLogicalType();
                        Schema.Type[] typeArray2 = typeArray = logicalType != null ? logicalType.getName() : null;
                        if (typeArray == null) {
                            anyValueDecoder = arg_0 -> LocalTimeSerializer.deserializeAvro$lambda$0$1$1(decoder, arg_0);
                            break;
                        }
                        if (Intrinsics.areEqual((Object)typeArray, (Object)"time-micros")) {
                            anyValueDecoder = arg_0 -> LocalTimeSerializer.deserializeAvro$lambda$0$1$2(decoder, arg_0);
                            break;
                        }
                        anyValueDecoder = null;
                        break;
                    }
                    case 3: {
                        anyValueDecoder = arg_0 -> LocalTimeSerializer.deserializeAvro$lambda$0$1$3(decoder, arg_0);
                        break;
                    }
                    default: {
                        anyValueDecoder = null;
                    }
                }
            }
        }
        AnyValueDecoder<LocalTime> anyValueDecoder4 = foundResolver$iv$iv = anyValueDecoder;
        if (anyValueDecoder4 == null) {
            boolean bl = false;
            typeArray = new Schema.Type[]{Schema.Type.LONG, Schema.Type.STRING};
            throw (Throwable)ExceptionsKt.UnexpectedDecodeSchemaError($this$deserializeAvro_u24lambda_u240, "LocalTime", Schema.Type.INT, typeArray);
        }
        LocalTime localTime = anyValueDecoder4.decodeAny($this$decodeResolvingAny$iv);
        Intrinsics.checkNotNullExpressionValue((Object)localTime, (String)"decodeResolvingAny(...)");
        return localTime;
    }

    @Override
    @NotNull
    public LocalTime deserializeGeneric(@NotNull Decoder decoder) {
        Intrinsics.checkNotNullParameter((Object)decoder, (String)"decoder");
        LocalTime localTime = LocalTime.parse(decoder.decodeString());
        Intrinsics.checkNotNullExpressionValue((Object)localTime, (String)"parse(...)");
        return localTime;
    }

    private static final LocalTime deserializeAvro$lambda$0$1$0(AvroDecoder $decoder, AvroDecoder $context_receiver_0) {
        Intrinsics.checkNotNullParameter((Object)$context_receiver_0, (String)"$context_receiver_0");
        return LocalTime.ofNanoOfDay((long)$decoder.decodeInt() * 1000000L);
    }

    private static final LocalTime deserializeAvro$lambda$0$1$1(AvroDecoder $decoder, AvroDecoder $context_receiver_0) {
        Intrinsics.checkNotNullParameter((Object)$context_receiver_0, (String)"$context_receiver_0");
        return LocalTime.ofNanoOfDay($decoder.decodeLong() * 1000000L);
    }

    private static final LocalTime deserializeAvro$lambda$0$1$2(AvroDecoder $decoder, AvroDecoder $context_receiver_0) {
        Intrinsics.checkNotNullParameter((Object)$context_receiver_0, (String)"$context_receiver_0");
        return LocalTime.ofNanoOfDay($decoder.decodeLong() * 1000L);
    }

    private static final LocalTime deserializeAvro$lambda$0$1$3(AvroDecoder $decoder, AvroDecoder $context_receiver_0) {
        Intrinsics.checkNotNullParameter((Object)$context_receiver_0, (String)"$context_receiver_0");
        return LocalTime.parse($decoder.decodeString());
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Schema.Type.values().length];
            try {
                nArray[Schema.Type.INT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Schema.Type.LONG.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Schema.Type.STRING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

