/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.policy.sketch.tinycache;

import com.github.benmanes.caffeine.cache.simulator.BasicSettings;
import com.github.benmanes.caffeine.cache.simulator.admission.tinycache.TinyCache;
import com.github.benmanes.caffeine.cache.simulator.policy.Policy;
import com.github.benmanes.caffeine.cache.simulator.policy.PolicyStats;
import com.google.common.primitives.Ints;
import com.typesafe.config.Config;

@Policy.PolicySpec(name="sketch.TinyCache")
public final class TinyCachePolicy
implements Policy.KeyOnlyPolicy {
    private final PolicyStats policyStats = new PolicyStats(this.name(), new Object[0]);
    private final TinyCache tinyCache;

    public TinyCachePolicy(Config config) {
        BasicSettings settings = new BasicSettings(config);
        int maximumSize = Ints.checkedCast((long)settings.maximumSize());
        this.tinyCache = new TinyCache((int)Math.ceil((double)maximumSize / 64.0), 64, settings.randomSeed());
    }

    @Override
    public void record(long key) {
        if (this.tinyCache.contains(key)) {
            this.policyStats.recordHit();
        } else {
            boolean evicted = this.tinyCache.addItem(key);
            this.policyStats.recordMiss();
            if (evicted) {
                this.policyStats.recordEviction();
            }
        }
    }

    @Override
    public PolicyStats stats() {
        return this.policyStats;
    }
}

