/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.repackaged.com.squareup.javapoet;

import com.bumptech.glide.repackaged.com.squareup.javapoet.ClassName;
import com.bumptech.glide.repackaged.com.squareup.javapoet.CodeBlock;
import com.bumptech.glide.repackaged.com.squareup.javapoet.CodeWriter;
import com.bumptech.glide.repackaged.com.squareup.javapoet.TypeSpec;
import com.bumptech.glide.repackaged.com.squareup.javapoet.Util;
import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Element;
import javax.tools.JavaFileObject;

public final class JavaFile {
    private static final Appendable NULL_APPENDABLE = new Appendable(){

        @Override
        public Appendable append(CharSequence charSequence) {
            return this;
        }

        @Override
        public Appendable append(CharSequence charSequence, int start, int end) {
            return this;
        }

        @Override
        public Appendable append(char c) {
            return this;
        }
    };
    public final CodeBlock fileComment;
    public final String packageName;
    public final TypeSpec typeSpec;
    public final boolean skipJavaLangImports;
    private final Set<String> staticImports;
    private final String indent;

    private JavaFile(Builder builder) {
        this.fileComment = builder.fileComment.build();
        this.packageName = builder.packageName;
        this.typeSpec = builder.typeSpec;
        this.skipJavaLangImports = builder.skipJavaLangImports;
        this.staticImports = Util.immutableSet(builder.staticImports);
        this.indent = builder.indent;
    }

    public void writeTo(Appendable out) throws IOException {
        CodeWriter importsCollector = new CodeWriter(NULL_APPENDABLE, this.indent, this.staticImports);
        this.emit(importsCollector);
        Map<String, ClassName> suggestedImports = importsCollector.suggestedImports();
        CodeWriter codeWriter = new CodeWriter(out, this.indent, suggestedImports, this.staticImports);
        this.emit(codeWriter);
    }

    public void writeTo(Filer filer) throws IOException {
        String fileName = this.packageName.isEmpty() ? this.typeSpec.name : this.packageName + "." + this.typeSpec.name;
        List<Element> originatingElements = this.typeSpec.originatingElements;
        JavaFileObject filerSourceFile = filer.createSourceFile(fileName, originatingElements.toArray(new Element[originatingElements.size()]));
        try (Writer writer = filerSourceFile.openWriter();){
            this.writeTo(writer);
        }
        catch (Exception e) {
            try {
                filerSourceFile.delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
    }

    private void emit(CodeWriter codeWriter) throws IOException {
        codeWriter.pushPackage(this.packageName);
        if (!this.fileComment.isEmpty()) {
            codeWriter.emitComment(this.fileComment);
        }
        if (!this.packageName.isEmpty()) {
            codeWriter.emit("package $L;\n", this.packageName);
            codeWriter.emit("\n");
        }
        if (!this.staticImports.isEmpty()) {
            for (String signature : this.staticImports) {
                codeWriter.emit("import static $L;\n", signature);
            }
            codeWriter.emit("\n");
        }
        int importedTypesCount = 0;
        for (ClassName className : new TreeSet<ClassName>(codeWriter.importedTypes().values())) {
            if (this.skipJavaLangImports && className.packageName().equals("java.lang")) continue;
            codeWriter.emit("import $L;\n", className);
            ++importedTypesCount;
        }
        if (importedTypesCount > 0) {
            codeWriter.emit("\n");
        }
        this.typeSpec.emit(codeWriter, null, Collections.emptySet());
        codeWriter.popPackage();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        return this.toString().equals(o.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        try {
            StringBuilder result = new StringBuilder();
            this.writeTo(result);
            return result.toString();
        }
        catch (IOException e) {
            throw new AssertionError();
        }
    }

    public static Builder builder(String packageName, TypeSpec typeSpec) {
        Util.checkNotNull(packageName, "packageName == null", new Object[0]);
        Util.checkNotNull(typeSpec, "typeSpec == null", new Object[0]);
        return new Builder(packageName, typeSpec);
    }

    public static final class Builder {
        private final String packageName;
        private final TypeSpec typeSpec;
        private final CodeBlock.Builder fileComment = CodeBlock.builder();
        private final Set<String> staticImports = new TreeSet<String>();
        private boolean skipJavaLangImports;
        private String indent = "  ";

        private Builder(String packageName, TypeSpec typeSpec) {
            this.packageName = packageName;
            this.typeSpec = typeSpec;
        }

        public Builder skipJavaLangImports(boolean skipJavaLangImports) {
            this.skipJavaLangImports = skipJavaLangImports;
            return this;
        }

        public JavaFile build() {
            return new JavaFile(this);
        }
    }
}

