/*
 * Decompiled with CFR 0.152.
 */
package com.github.danielflower.mavenplugins.gitlog.renderers;

import com.github.danielflower.mavenplugins.gitlog.renderers.AsciidocLinkConverter;
import com.github.danielflower.mavenplugins.gitlog.renderers.FileRenderer;
import com.github.danielflower.mavenplugins.gitlog.renderers.Formatter;
import com.github.danielflower.mavenplugins.gitlog.renderers.MessageConverter;
import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.logging.Log;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTag;

public class AsciidocReleaseNotesRenderer
extends FileRenderer {
    private boolean previousWasTag = false;
    private final boolean fullGitMessage;
    protected final MessageConverter messageConverter;
    private AsciidocLinkConverter asciidocLinkConverter;
    private String asciidocHeading;
    private boolean asciidocTableView;
    private String asciidocTableViewHeader1;
    private String asciidocTableViewHeader2;

    public AsciidocReleaseNotesRenderer(Log log, File targetFolder, String filename, boolean fullGitMessage, MessageConverter messageConverter, String asciidocHeading, boolean asciidocTableView, String asciidocTableViewHeader1, String asciidocTableViewHeader2) throws IOException {
        super(log, targetFolder, filename, false);
        this.fullGitMessage = fullGitMessage;
        this.messageConverter = messageConverter;
        this.asciidocHeading = asciidocHeading == null ? "=" : asciidocHeading;
        this.asciidocTableView = asciidocTableView;
        this.asciidocTableViewHeader1 = asciidocTableViewHeader1 == null ? "Date" : asciidocTableViewHeader1;
        this.asciidocTableViewHeader2 = asciidocTableViewHeader2 == null ? "Commit" : asciidocTableViewHeader2;
        this.asciidocLinkConverter = new AsciidocLinkConverter(log);
    }

    @Override
    public void renderHeader(String reportTitle) throws IOException {
        if (reportTitle != null && reportTitle.length() > 0) {
            this.writer.write(this.asciidocHeading + " ");
            this.writer.write(reportTitle);
            this.writer.write(Formatter.NEW_LINE);
            if (this.asciidocTableView) {
                this.renderTableHeader();
            }
        }
    }

    @Override
    public void renderTag(RevTag tag) throws IOException {
        if (!this.previousWasTag) {
            this.writer.write(Formatter.NEW_LINE);
        } else if (this.asciidocTableView) {
            this.renderTableFooter();
            this.writer.write(this.asciidocHeading + "= ");
            this.writer.write(tag.getTagName());
            this.renderTableHeader();
        } else {
            this.writer.write("*");
            this.writer.write(tag.getTagName());
            this.writer.write("*");
            this.writer.write(" +");
            this.writer.write(Formatter.NEW_LINE);
        }
        this.previousWasTag = true;
    }

    @Override
    public void renderCommit(RevCommit commit) throws IOException {
        String message = null;
        message = this.fullGitMessage ? this.messageConverter.formatCommitMessage(commit.getFullMessage()) : this.messageConverter.formatCommitMessage(commit.getShortMessage());
        message = this.asciidocLinkConverter.formatCommitMessage(message);
        if (this.asciidocTableView) {
            this.renderTableCommit(commit, message);
        } else {
            this.writer.write(Formatter.formatDateTime(commit.getCommitTime()) + "     " + message);
            this.writer.write(" " + Formatter.formatCommiter(commit.getCommitterIdent()));
            this.writer.write(" +");
            this.writer.write(Formatter.NEW_LINE);
        }
        this.previousWasTag = false;
    }

    private void renderTableCommit(RevCommit commit, String message) throws IOException {
        if (this.asciidocTableView) {
            this.writer.write(Formatter.NEW_LINE);
            this.writer.write("|");
            this.writer.write(Formatter.formatDateTime(commit.getCommitTime()) + " | " + message);
            this.writer.write(" (" + commit.getCommitterIdent().getName() + ")");
            this.writer.write(Formatter.NEW_LINE);
        }
    }

    public void renderTableHeader() throws IOException {
        if (this.asciidocTableView) {
            this.writer.write(Formatter.NEW_LINE);
            this.writer.write("|===");
            this.writer.write(Formatter.NEW_LINE);
            this.writer.write("|" + this.asciidocTableViewHeader1 + " | " + this.asciidocTableViewHeader2);
            this.writer.write(Formatter.NEW_LINE);
        }
    }

    public void renderTableFooter() throws IOException {
        if (this.asciidocTableView) {
            this.writer.write(Formatter.NEW_LINE);
            this.writer.write("|===");
            this.writer.write(Formatter.NEW_LINE);
        }
    }

    @Override
    public void renderFooter() throws IOException {
        if (this.asciidocTableView) {
            this.renderTableFooter();
        }
    }
}

