/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.jaxws;

import com.github.davidmoten.guavamini.Sets;
import com.github.davidmoten.jaxws.SchemaGenMain;
import com.github.davidmoten.jaxws.WsGenMain;
import com.github.davidmoten.jaxws.WsImportMain;
import com.github.davidmoten.jaxws.XjcMain;
import java.util.Optional;
import java.util.Set;

enum JaxCommand {
    WSGEN(WsGenMain.class, Sets.newHashSet((Object[])new String[]{"-r", "-d", "-s"}), Optional.of("-s"), Optional.of("-r")),
    WSIMPORT(WsImportMain.class, Sets.newHashSet((Object[])new String[]{"-d", "-s"}), Optional.of("-s"), Optional.empty()),
    XJC(XjcMain.class, Sets.newHashSet((Object[])new String[]{"-d"}), Optional.of("-d"), Optional.empty()),
    SCHEMAGEN(SchemaGenMain.class, Sets.newHashSet((Object[])new String[]{"-d"}), Optional.of("-d"), Optional.empty());

    private final Class<?> mainClass;
    private final Set<String> directoryParameters;
    private final Optional<String> sourceParameter;
    private final Optional<String> resourceParameter;

    private JaxCommand(Class<?> mainClass, Set<String> directoryParameters, Optional<String> sourceParameter, Optional<String> resourceParameter) {
        this.mainClass = mainClass;
        this.directoryParameters = directoryParameters;
        this.sourceParameter = sourceParameter;
        this.resourceParameter = resourceParameter;
        sourceParameter.ifPresent(x -> {
            if (!directoryParameters.contains(x)) {
                throw new IllegalArgumentException();
            }
        });
        resourceParameter.ifPresent(x -> {
            if (!directoryParameters.contains(x)) {
                throw new IllegalArgumentException();
            }
        });
    }

    Class<?> mainClass() {
        return this.mainClass;
    }

    Set<String> getDirectoryParameters() {
        return this.directoryParameters;
    }

    public Optional<String> getSourceParameter() {
        return this.sourceParameter;
    }

    public Optional<String> getResourceParameter() {
        return this.resourceParameter;
    }
}

