/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.junit;

import com.github.davidmoten.junit.Util;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public final class Files {
    private Files() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] readBytes(File file) {
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));){
            byte[] byArray = Util.read(in);
            return byArray;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static String readString(File file, Charset charset) {
        return new String(Files.readBytes(file), charset);
    }

    public static String readUtf8(File file) {
        return Files.readString(file, StandardCharsets.UTF_8);
    }
}

