/*
 * Copyright (c) 2006 Rick Mugridge, www.RimuResearch.com
 * Released under the terms of the GNU General Public License version 2 or later.
 * Written: 20/08/2006
*/

package fitlibrary.specify.exception;

import fitlibrary.traverse.DomainAdapter;

public class ExceptionThrownByNestedEquals implements DomainAdapter {
	public Project project() {
		return new Project();
	}
	public User findUser(@SuppressWarnings("unused") String key) { 
		return new User();
	}
	public static class Project {
		public User getLeader() {
			return new User();
		}
	}
	public static class User {
		@Override
		public boolean equals(@SuppressWarnings("unused") Object object) {
			throw new ForcedException();
		}
	}
	public Object getSystemUnderTest() {
		return null;
	}
}
