/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.analytics;

import com.google.gdata.data.BaseFeed;
import com.google.gdata.data.Extension;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.data.analytics.Aggregates;
import com.google.gdata.data.analytics.ContainsSampledData;
import com.google.gdata.data.analytics.DataEntry;
import com.google.gdata.data.analytics.DataSource;
import com.google.gdata.data.analytics.EndDate;
import com.google.gdata.data.analytics.Segment;
import com.google.gdata.data.analytics.StartDate;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataFeed
extends BaseFeed<DataFeed, DataEntry> {
    public DataFeed() {
        super(DataEntry.class);
        this.setKind("analytics#data");
    }

    public DataFeed(BaseFeed<?, ?> sourceFeed) {
        super(DataEntry.class, sourceFeed);
    }

    public void declareExtensions(ExtensionProfile extProfile) {
        if (extProfile.isDeclared(DataFeed.class)) {
            return;
        }
        super.declareExtensions(extProfile);
        extProfile.declare(DataFeed.class, Aggregates.class);
        new Aggregates().declareExtensions(extProfile);
        extProfile.declare(DataFeed.class, ContainsSampledData.class);
        extProfile.declare(DataFeed.class, DataSource.getDefaultDescription(false, true));
        new DataSource().declareExtensions(extProfile);
        extProfile.declare(DataFeed.class, EndDate.getDefaultDescription(true, false));
        extProfile.declare(DataFeed.class, Segment.getDefaultDescription(false, true));
        new Segment().declareExtensions(extProfile);
        extProfile.declare(DataFeed.class, StartDate.getDefaultDescription(true, false));
    }

    public Aggregates getAggregates() {
        return (Aggregates)this.getExtension(Aggregates.class);
    }

    public void setAggregates(Aggregates aggregates) {
        if (aggregates == null) {
            this.removeExtension(Aggregates.class);
        } else {
            this.setExtension((Extension)aggregates);
        }
    }

    public boolean hasAggregates() {
        return this.hasExtension(Aggregates.class);
    }

    public ContainsSampledData getContainsSampledData() {
        return (ContainsSampledData)this.getExtension(ContainsSampledData.class);
    }

    public void setContainsSampledData(ContainsSampledData containsSampledData) {
        if (containsSampledData == null) {
            this.removeExtension(ContainsSampledData.class);
        } else {
            this.setExtension((Extension)containsSampledData);
        }
    }

    public boolean hasContainsSampledData() {
        return this.hasExtension(ContainsSampledData.class);
    }

    public List<DataSource> getDataSources() {
        return this.getRepeatingExtension(DataSource.class);
    }

    public void addDataSource(DataSource dataSource) {
        this.getDataSources().add(dataSource);
    }

    public boolean hasDataSources() {
        return this.hasRepeatingExtension(DataSource.class);
    }

    public EndDate getEndDate() {
        return (EndDate)this.getExtension(EndDate.class);
    }

    public void setEndDate(EndDate endDate) {
        if (endDate == null) {
            this.removeExtension(EndDate.class);
        } else {
            this.setExtension((Extension)endDate);
        }
    }

    public boolean hasEndDate() {
        return this.hasExtension(EndDate.class);
    }

    public List<Segment> getSegments() {
        return this.getRepeatingExtension(Segment.class);
    }

    public void addSegment(Segment segment) {
        this.getSegments().add(segment);
    }

    public boolean hasSegments() {
        return this.hasRepeatingExtension(Segment.class);
    }

    public StartDate getStartDate() {
        return (StartDate)this.getExtension(StartDate.class);
    }

    public void setStartDate(StartDate startDate) {
        if (startDate == null) {
            this.removeExtension(StartDate.class);
        } else {
            this.setExtension((Extension)startDate);
        }
    }

    public boolean hasStartDate() {
        return this.hasExtension(StartDate.class);
    }

    protected void validate() {
    }

    public String toString() {
        return "{DataFeed " + super.toString() + "}";
    }
}

