/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.client.appsforyourdomain.audit;

import com.google.gdata.data.appsforyourdomain.generic.GenericEntry;
import java.text.DateFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class AccountInfo {
    private String requestId;
    private String userEmailAddress;
    private String adminEmailAddress;
    private String status;
    private Date requestDate;
    private Date completedDate;
    private int numberOfFiles;
    private String[] fileUrls;
    private Date expiredDate;
    private static DateFormat DATE_FORMAT = null;

    public AccountInfo() {
    }

    public AccountInfo(GenericEntry entry) {
        this.completedDate = this.checkDateAndParse(entry.getProperty("completedDate"));
        this.requestDate = this.checkDateAndParse(entry.getProperty("requestDate"));
        this.expiredDate = this.checkDateAndParse(entry.getProperty("expiredDate"));
        this.requestId = entry.getProperty("requestId");
        this.userEmailAddress = entry.getProperty("userEmailAddress");
        this.adminEmailAddress = entry.getProperty("adminEmailAddress");
        this.status = entry.getProperty("status");
        int n = this.numberOfFiles = entry.getProperty("numberOfFiles") != null ? Integer.parseInt(entry.getProperty("numberOfFiles")) : this.numberOfFiles;
        if (this.numberOfFiles > 0) {
            this.fileUrls = new String[this.numberOfFiles];
            for (int fileIndex = 0; fileIndex < this.numberOfFiles; ++fileIndex) {
                this.fileUrls[fileIndex] = entry.getProperty("fileUrl" + fileIndex);
            }
        }
    }

    private Date checkDateAndParse(String date) {
        return date != null ? DATE_FORMAT.parse(date, new ParsePosition(0)) : null;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public void setAdminEmailAddress(String adminEmailAddress) {
        this.adminEmailAddress = adminEmailAddress;
    }

    public String getAdminEmailAddress() {
        return this.adminEmailAddress;
    }

    public void setUserEmailAddress(String userEmailAddress) {
        this.userEmailAddress = userEmailAddress;
    }

    public String getUserEmailAddress() {
        return this.userEmailAddress;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Date getRequestDate() {
        return this.requestDate;
    }

    public void setRequestDate(Date requestDate) {
        this.requestDate = requestDate;
    }

    public Date getCompletedDate() {
        return this.completedDate;
    }

    public void setCompletedDate(Date completedDate) {
        this.completedDate = completedDate;
    }

    public int getNumberOfFiles() {
        return this.numberOfFiles;
    }

    public void setNumberOfFiles(int numberOfFiles) {
        this.numberOfFiles = numberOfFiles;
    }

    public String[] getFileUrls() {
        return this.fileUrls;
    }

    public void setFileUrls(String[] fileUrls) {
        this.fileUrls = fileUrls;
    }

    public Date getExpiredDate() {
        return this.expiredDate;
    }

    public void setExpiredDate(Date expiredDate) {
        this.expiredDate = expiredDate;
    }

    public GenericEntry toGenericEntry() {
        GenericEntry entry = new GenericEntry();
        entry.addProperty("requestId", this.requestId);
        if (this.completedDate != null) {
            entry.addProperty("completedDate", DATE_FORMAT.format(this.completedDate));
        }
        if (this.requestDate != null) {
            entry.addProperty("beginDate", DATE_FORMAT.format(this.requestDate));
        }
        if (this.numberOfFiles != 0) {
            entry.addProperty("numberOfFiles", String.valueOf(this.numberOfFiles));
        }
        entry.addProperty("userEmailAddress", this.userEmailAddress);
        entry.addProperty("adminEmailAddress", this.adminEmailAddress);
        entry.addProperty("status", this.status);
        return entry;
    }

    static {
        DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd hh:mm");
        DATE_FORMAT.setTimeZone(TimeZone.getTimeZone("UTC"));
        DATE_FORMAT.setLenient(false);
    }
}

