/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.finance;

import com.google.gdata.data.AttributeGenerator;
import com.google.gdata.data.AttributeHelper;
import com.google.gdata.data.DateTime;
import com.google.gdata.data.Extension;
import com.google.gdata.data.ExtensionDescription;
import com.google.gdata.data.ExtensionPoint;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.data.finance.Commission;
import com.google.gdata.data.finance.Price;
import com.google.gdata.util.ParseException;

@ExtensionDescription.Default(nsAlias="gf", nsUri="http://schemas.google.com/finance/2007", localName="transactionData")
public class TransactionData
extends ExtensionPoint {
    static final String XML_NAME = "transactionData";
    private static final String DATE = "date";
    private static final String NOTES = "notes";
    private static final String SHARES = "shares";
    private static final String TYPE = "type";
    private DateTime date = null;
    private String notes = null;
    private Double shares = null;
    private String type = null;

    public TransactionData() {
    }

    public TransactionData(DateTime date, String notes, Double shares, String type) {
        this.setDate(date);
        this.setNotes(notes);
        this.setShares(shares);
        this.setType(type);
        this.setImmutable(true);
    }

    public void declareExtensions(ExtensionProfile extProfile) {
        if (extProfile.isDeclared(TransactionData.class)) {
            return;
        }
        extProfile.declare(TransactionData.class, Commission.class);
        new Commission().declareExtensions(extProfile);
        extProfile.declare(TransactionData.class, Price.class);
        new Price().declareExtensions(extProfile);
    }

    public Commission getCommission() {
        return (Commission)this.getExtension(Commission.class);
    }

    public void setCommission(Commission commission) {
        if (commission == null) {
            this.removeExtension(Commission.class);
        } else {
            this.setExtension((Extension)commission);
        }
    }

    public boolean hasCommission() {
        return this.hasExtension(Commission.class);
    }

    public DateTime getDate() {
        return this.date;
    }

    public void setDate(DateTime date) {
        this.throwExceptionIfImmutable();
        this.date = date;
    }

    public boolean hasDate() {
        return this.getDate() != null;
    }

    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String notes) {
        this.throwExceptionIfImmutable();
        this.notes = notes;
    }

    public boolean hasNotes() {
        return this.getNotes() != null;
    }

    public Price getPrice() {
        return (Price)this.getExtension(Price.class);
    }

    public void setPrice(Price price) {
        if (price == null) {
            this.removeExtension(Price.class);
        } else {
            this.setExtension((Extension)price);
        }
    }

    public boolean hasPrice() {
        return this.hasExtension(Price.class);
    }

    public Double getShares() {
        return this.shares;
    }

    public void setShares(Double shares) {
        this.throwExceptionIfImmutable();
        this.shares = shares;
    }

    public boolean hasShares() {
        return this.getShares() != null;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.throwExceptionIfImmutable();
        this.type = type;
    }

    public boolean hasType() {
        return this.getType() != null;
    }

    protected void validate() {
        if (this.type == null) {
            TransactionData.throwExceptionForMissingAttribute((String)TYPE);
        }
    }

    public static ExtensionDescription getDefaultDescription(boolean required, boolean repeatable) {
        ExtensionDescription desc = ExtensionDescription.getDefaultDescription(TransactionData.class);
        desc.setRequired(required);
        desc.setRepeatable(repeatable);
        return desc;
    }

    protected void putAttributes(AttributeGenerator generator) {
        generator.put(DATE, (Object)this.date);
        generator.put((Object)NOTES, (Object)this.notes);
        generator.put(SHARES, (Object)this.shares);
        generator.put((Object)TYPE, (Object)this.type);
    }

    protected void consumeAttributes(AttributeHelper helper) throws ParseException {
        this.date = helper.consumeDateTime(DATE, false);
        this.notes = helper.consume(NOTES, false);
        this.shares = helper.consumeDouble(SHARES, false);
        this.type = helper.consume(TYPE, true);
    }

    public String toString() {
        return "{TransactionData date=" + this.date + " notes=" + this.notes + " shares=" + this.shares + " type=" + this.type + "}";
    }
}

