/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.media;

import com.google.gdata.client.media.MediaService;
import com.google.gdata.data.Entry;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.data.IAtom;
import com.google.gdata.data.ParseSource;
import com.google.gdata.util.ContentType;
import com.google.gdata.util.ServiceException;
import com.google.gdata.util.common.base.Preconditions;
import com.google.gdata.wireformats.AltFormat;
import com.google.gdata.wireformats.AltRegistry;
import com.google.gdata.wireformats.input.ForwardingInputProperties;
import com.google.gdata.wireformats.input.InputParser;
import com.google.gdata.wireformats.input.InputProperties;
import com.google.gdata.wireformats.input.InputPropertiesBuilder;
import com.google.gdata.wireformats.output.ForwardingOutputProperties;
import com.google.gdata.wireformats.output.OutputGenerator;
import com.google.gdata.wireformats.output.OutputProperties;
import com.google.gdata.wireformats.output.OutputPropertiesBuilder;
import java.awt.datatransfer.DataFlavor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataContentHandler;
import javax.activation.DataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GDataContentHandler
implements DataContentHandler {
    private static final InputProperties DEFAULT_INPUT_PROPERTIES = ((InputPropertiesBuilder)((InputPropertiesBuilder)((InputPropertiesBuilder)new InputPropertiesBuilder().setAltRegistry(MediaService.getDefaultAltRegistry())).setContentType(ContentType.ATOM)).setExpectType(Entry.class).setExtensionProfile(new ExtensionProfile())).build();
    private static final ThreadLocal<InputProperties> threadInputProperties = new ThreadLocal<InputProperties>(){

        @Override
        protected InputProperties initialValue() {
            return DEFAULT_INPUT_PROPERTIES;
        }
    };
    private static final OutputProperties DEFAULT_OUTPUT_PROPERTIES = ((OutputPropertiesBuilder)((OutputPropertiesBuilder)new OutputPropertiesBuilder().setAltRegistry(MediaService.getDefaultAltRegistry())).setExtensionProfile(new ExtensionProfile())).build();
    private static final ThreadLocal<OutputProperties> threadOutputProperties = new ThreadLocal<OutputProperties>(){

        @Override
        protected OutputProperties initialValue() {
            return DEFAULT_OUTPUT_PROPERTIES;
        }
    };

    public static InputProperties setThreadInputProperties(InputProperties inputProperties) {
        Preconditions.checkNotNull((Object)inputProperties, (Object)"inputProperties");
        InputProperties currentProperties = GDataContentHandler.getThreadInputProperties();
        threadInputProperties.set(inputProperties);
        return currentProperties;
    }

    public static InputProperties getThreadInputProperties() {
        return threadInputProperties.get();
    }

    public static OutputProperties setThreadOutputProperties(OutputProperties outputProperties) {
        Preconditions.checkNotNull((Object)outputProperties, (Object)"outputProperties");
        OutputProperties currentProperties = GDataContentHandler.getThreadOutputProperties();
        threadOutputProperties.set(outputProperties);
        return currentProperties;
    }

    public static OutputProperties getThreadOutputProperties() {
        return threadOutputProperties.get();
    }

    public DataFlavor[] getTransferDataFlavors() {
        throw new UnsupportedOperationException("No DataFlavor support");
    }

    public Object getTransferData(DataFlavor df, DataSource ds) {
        throw new UnsupportedOperationException("No DataFlavor support");
    }

    private <T> Object parseAtom(InputParser<?> parser, InputStream inputStream, final ContentType contentType, InputProperties inputProperties, Class<T> resultClass) throws IOException, ServiceException {
        Preconditions.checkArgument((boolean)parser.getResultType().isAssignableFrom(IAtom.class), (Object)"Parser does not handle atom content");
        return parser.parse(new ParseSource(inputStream), (InputProperties)new ForwardingInputProperties(inputProperties){

            public ContentType getContentType() {
                return contentType;
            }
        }, resultClass);
    }

    public Object getContent(DataSource ds) throws IOException {
        AltFormat altFormat;
        InputProperties inputProperties = GDataContentHandler.getThreadInputProperties();
        ContentType contentType = new ContentType(ds.getContentType());
        AltRegistry altRegistry = inputProperties.getAltRegistry();
        InputParser parser = altRegistry.getParser(altFormat = altRegistry.lookupType(contentType));
        if (parser == null) {
            throw new IOException("Invalid multipart content: " + contentType);
        }
        try {
            return this.parseAtom(parser, ds.getInputStream(), contentType, inputProperties, inputProperties.getRootType());
        }
        catch (ServiceException se) {
            IOException ioe = new IOException("Error parsing content");
            ioe.initCause(se);
            throw ioe;
        }
    }

    private void generateAtom(OutputGenerator<?> generator, OutputStream outputStream, OutputProperties outputProperties, Object source) throws IOException {
        Preconditions.checkArgument((boolean)generator.getSourceType().isAssignableFrom(IAtom.class), (Object)"Generator does not handle atom content");
        Preconditions.checkArgument((boolean)(source instanceof IAtom), (Object)"Source object must be Atom content");
        IAtom atomSource = (IAtom)source;
        OutputGenerator<?> atomGenerator = generator;
        atomGenerator.generate(outputStream, outputProperties, (Object)atomSource);
    }

    public void writeTo(Object obj, String mimeType, OutputStream os) throws IOException {
        Preconditions.checkNotNull((Object)obj, (Object)"obj");
        OutputProperties outputProperties = GDataContentHandler.getThreadOutputProperties();
        AltRegistry altRegistry = outputProperties.getAltRegistry();
        ContentType contentType = new ContentType(mimeType);
        final AltFormat altFormat = altRegistry.lookupType(contentType);
        OutputGenerator generator = altRegistry.getGenerator(altFormat);
        if (generator == null) {
            throw new IllegalStateException("Unable to generate media: " + contentType);
        }
        this.generateAtom(generator, os, (OutputProperties)new ForwardingOutputProperties(outputProperties){

            public ContentType getContentType() {
                return altFormat.getContentType();
            }
        }, obj);
    }
}

