/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.webmastertools;

import com.google.gdata.data.AbstractExtension;
import com.google.gdata.data.AttributeGenerator;
import com.google.gdata.data.AttributeHelper;
import com.google.gdata.data.ExtensionDescription;
import com.google.gdata.util.ParseException;

@ExtensionDescription.Default(nsAlias="wt", nsUri="http://schemas.google.com/webmasters/tools/2007", localName="issue-type")
public class CrawlIssueIssueType
extends AbstractExtension {
    static final String XML_NAME = "issue-type";
    private static final AttributeHelper.EnumToAttributeValue<IssueType> ISSUETYPE_ENUM_TO_ATTRIBUTE_VALUE = new AttributeHelper.EnumToAttributeValue<IssueType>(){

        public String getAttributeValue(IssueType enumValue) {
            return enumValue.toValue();
        }
    };
    private IssueType issueType = null;

    public CrawlIssueIssueType() {
    }

    public CrawlIssueIssueType(IssueType issueType) {
        this.setIssueType(issueType);
        this.setImmutable(true);
    }

    public IssueType getIssueType() {
        return this.issueType;
    }

    public void setIssueType(IssueType issueType) {
        this.throwExceptionIfImmutable();
        this.issueType = issueType;
    }

    public boolean hasIssueType() {
        return this.getIssueType() != null;
    }

    protected void validate() {
    }

    public static ExtensionDescription getDefaultDescription(boolean required, boolean repeatable) {
        ExtensionDescription desc = ExtensionDescription.getDefaultDescription(CrawlIssueIssueType.class);
        desc.setRequired(required);
        desc.setRepeatable(repeatable);
        return desc;
    }

    protected void putAttributes(AttributeGenerator generator) {
        generator.setContent(ISSUETYPE_ENUM_TO_ATTRIBUTE_VALUE.getAttributeValue((Enum)this.issueType));
    }

    protected void consumeAttributes(AttributeHelper helper) throws ParseException {
        this.issueType = (IssueType)helper.consumeEnum(null, false, IssueType.class, null, ISSUETYPE_ENUM_TO_ATTRIBUTE_VALUE);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!this.sameClassAs(obj)) {
            return false;
        }
        CrawlIssueIssueType other = (CrawlIssueIssueType)((Object)obj);
        return CrawlIssueIssueType.eq((Object)((Object)this.issueType), (Object)((Object)other.issueType));
    }

    public int hashCode() {
        int result = ((Object)((Object)this)).getClass().hashCode();
        if (this.issueType != null) {
            result = 37 * result + this.issueType.hashCode();
        }
        return result;
    }

    public String toString() {
        return "{CrawlIssueIssueType issueType=" + (Object)((Object)this.issueType) + "}";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum IssueType {
        HTTP_ERROR("http-error"),
        IN_SITEMAP("in-sitemap"),
        NEWS_ERROR("news-error"),
        NOT_FOLLOWED("not-followed"),
        NOT_FOUND("not-found"),
        RESTRICTED_ROBOTS_TXT("restricted-robots-txt"),
        TIMED_OUT("timed-out"),
        UNREACHABLE("unreachable");

        private final String value;

        private IssueType(String value) {
            this.value = value;
        }

        public String toValue() {
            return this.value;
        }
    }
}

