/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.webmastertools;

import com.google.gdata.data.BaseEntry;
import com.google.gdata.data.Category;
import com.google.gdata.data.Extension;
import com.google.gdata.data.ExtensionDescription;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.data.Kind;
import com.google.gdata.data.ValueConstruct;
import com.google.gdata.data.webmastertools.Namespaces;
import com.google.gdata.data.webmastertools.SitemapsEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Kind.Term(value="http://schemas.google.com/webmasters/tools/2007#sitemap-regular")
public class SitemapsRegularEntry
extends SitemapsEntry<SitemapsRegularEntry> {
    private static final String SITEMAP_TYPE = "sitemap-type";
    private static final Category CATEGORY = Namespaces.createCategory("http://schemas.google.com/webmasters/tools/2007#sitemap-regular");

    public SitemapsRegularEntry() {
        this.getCategories().add(CATEGORY);
    }

    public SitemapsRegularEntry(BaseEntry<?> sourceEntry) {
        super(sourceEntry);
        this.getCategories().add(CATEGORY);
    }

    @Override
    public void declareExtensions(ExtensionProfile extProfile) {
        super.declareExtensions(extProfile);
        extProfile.declare(SitemapsRegularEntry.class, ExtensionDescription.getDefaultDescription(SitemapType.class));
    }

    public void setSitemapType(String value) {
        SitemapType type = (SitemapType)this.getExtension(SitemapType.class);
        if (type == null) {
            type = new SitemapType();
            this.setExtension((Extension)type);
        }
        type.setValue(value);
    }

    public String getSitemapType() {
        SitemapType type = (SitemapType)this.getExtension(SitemapType.class);
        if (type == null) {
            return null;
        }
        return type.getValue();
    }

    protected void validate() throws IllegalStateException {
        super.validate();
        if (this.getSitemapType() == null) {
            throw new IllegalStateException("sitemap-type is not set");
        }
    }

    @ExtensionDescription.Default(nsAlias="wt", nsUri="http://schemas.google.com/webmasters/tools/2007", localName="sitemap-type")
    public static class SitemapType
    extends ValueConstruct {
        public SitemapType() {
            super(Namespaces.WT_NAMESPACE, SitemapsRegularEntry.SITEMAP_TYPE, null);
        }
    }
}

