/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.youtube;

import com.google.gdata.data.BaseEntry;
import com.google.gdata.data.Content;
import com.google.gdata.data.Extension;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.data.Kind;
import com.google.gdata.data.MediaContent;
import com.google.gdata.data.PubControl;
import com.google.gdata.data.media.MediaEntry;
import com.google.gdata.data.youtube.EntryUtils;
import com.google.gdata.data.youtube.YouTubeNamespace;
import com.google.gdata.data.youtube.YtDerived;
import com.google.gdata.data.youtube.YtFormatInfo;
import com.google.gdata.data.youtube.YtPublicationState;
import com.google.gdata.util.ParseException;
import java.io.IOException;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Kind.Term(value="http://gdata.youtube.com/schemas/2007#captionTrack")
public class CaptionTrackEntry
extends MediaEntry<CaptionTrackEntry> {
    public CaptionTrackEntry() {
        EntryUtils.setKind(this, "http://gdata.youtube.com/schemas/2007#captionTrack");
    }

    public CaptionTrackEntry(BaseEntry<?> base) {
        super(base);
        EntryUtils.setKind(this, "http://gdata.youtube.com/schemas/2007#captionTrack");
    }

    public String getLanguageCode() {
        Content content = this.getContent();
        return content == null ? null : content.getLang();
    }

    public void setPublicationState(YtPublicationState state) {
        PubControl control = this.getPubControl();
        if (state == null) {
            if (control == null) {
                return;
            }
            control.removeExtension(YtPublicationState.class);
            if (!control.isDraft() && control.getExtensions().isEmpty()) {
                this.setPubControl(null);
            }
        } else {
            if (control == null) {
                control = new PubControl();
                this.setPubControl(control);
            }
            control.setExtension((Extension)state);
        }
    }

    public YtPublicationState getPublicationState() {
        return this.getPubControl() == null ? null : (YtPublicationState)this.getPubControl().getExtension(YtPublicationState.class);
    }

    public void setDerived(YtDerived derived) {
        if (derived != null) {
            this.setExtension((Extension)derived);
        } else {
            this.removeExtension(YtDerived.class);
        }
    }

    public YtDerived getDerived() {
        return (YtDerived)this.getExtension(YtDerived.class);
    }

    public void setFormatInfo(YtFormatInfo info) {
        if (info != null) {
            this.setExtension((Extension)info);
        } else {
            this.removeExtension(YtFormatInfo.class);
        }
    }

    public YtFormatInfo getFormatInfo() {
        return (YtFormatInfo)this.getExtension(YtFormatInfo.class);
    }

    public YtFormatInfo getOrCreateFormatInfo() {
        YtFormatInfo info = this.getFormatInfo();
        if (info == null) {
            info = new YtFormatInfo();
            this.setFormatInfo(info);
        }
        return (YtFormatInfo)this.getExtension(YtFormatInfo.class);
    }

    public boolean hasAutomaticSpeechRecognition() {
        YtDerived derived = (YtDerived)this.getExtension(YtDerived.class);
        return derived != null && derived.getContent().equals("speechRecognition");
    }

    public void setAutomaticSpeechRecognition(boolean asr) {
        if (asr) {
            this.setExtension((Extension)new YtDerived("speechRecognition"));
        } else {
            this.removeExtension(YtDerived.class);
        }
    }

    protected Content.ChildHandlerInfo getContentHandlerInfo(ExtensionProfile extProfile, Attributes attrs) throws ParseException, IOException {
        return MediaContent.getChildHandler((ExtensionProfile)extProfile, (Attributes)attrs);
    }

    public void declareExtensions(ExtensionProfile extProfile) {
        super.declareExtensions(extProfile);
        extProfile.declare(CaptionTrackEntry.class, YtDerived.class);
        extProfile.declare(CaptionTrackEntry.class, YtFormatInfo.class);
        extProfile.declareAdditionalNamespace(YouTubeNamespace.NS);
        extProfile.declare(PubControl.class, YtPublicationState.class);
        extProfile.declareArbitraryXmlExtension(CaptionTrackEntry.class);
    }
}

