/*
 * Decompiled with CFR 0.152.
 */
package com.github.eirslett.maven.plugins.frontend.lib;

import com.github.eirslett.maven.plugins.frontend.lib.ArchiveExtractionException;
import com.github.eirslett.maven.plugins.frontend.lib.ArchiveExtractor;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;

final class DefaultArchiveExtractor
implements ArchiveExtractor {
    DefaultArchiveExtractor() {
    }

    @Override
    public void extract(String archive, String destinationDirectory) throws ArchiveExtractionException {
        try {
            File archiveFile = new File(archive);
            FileInputStream fis = new FileInputStream(archiveFile);
            TarArchiveInputStream tarIn = new TarArchiveInputStream((InputStream)new GzipCompressorInputStream((InputStream)fis));
            TarArchiveEntry tarEntry = tarIn.getNextTarEntry();
            while (tarEntry != null) {
                File destPath = new File(destinationDirectory + File.separator + tarEntry.getName());
                if (tarEntry.isDirectory()) {
                    destPath.mkdirs();
                } else {
                    if (!destPath.getParentFile().exists()) {
                        destPath.getParentFile().mkdirs();
                    }
                    destPath.createNewFile();
                    boolean isExecutable = (tarEntry.getMode() & 0x40) > 0;
                    destPath.setExecutable(isExecutable);
                    byte[] btoRead = new byte[8024];
                    BufferedOutputStream bout = new BufferedOutputStream(new FileOutputStream(destPath));
                    int len = 0;
                    while ((len = tarIn.read(btoRead)) != -1) {
                        bout.write(btoRead, 0, len);
                    }
                    bout.close();
                }
                tarEntry = tarIn.getNextTarEntry();
            }
            tarIn.close();
        }
        catch (IOException e) {
            throw new ArchiveExtractionException("Could not extract archive: '" + archive + "'", e);
        }
    }
}

