/*
 * Decompiled with CFR 0.152.
 */
package com.eugenenosenko.conventional.changelog.core;

import com.eugenenosenko.conventional.changelog.core.ChangeLogEntryResolver;
import com.eugenenosenko.conventional.changelog.core.CommitType;
import com.eugenenosenko.conventional.changelog.core.ConventionalCommit;
import com.eugenenosenko.conventional.changelog.core.entry.ListItemEntry;
import com.eugenenosenko.conventional.changelog.core.entry.ReleaseEntry;
import com.eugenenosenko.conventional.changelog.core.entry.SummaryEntry;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;

public final class DefaultChangeLogEntryResolver
implements ChangeLogEntryResolver {
    @Override
    public ReleaseEntry.Builder resolveChangeLogEntry(List<ConventionalCommit> conventionalCommits) {
        ReleaseEntry.Builder releaseEntryBuilder = new ReleaseEntry.Builder();
        SummaryEntry breakingChanges = new SummaryEntry("BREAKING CHANGES");
        Map<CommitType, Set<ConventionalCommit>> sortedMap = DefaultChangeLogEntryResolver.groupByCommitType(conventionalCommits);
        for (CommitType type : sortedMap.keySet()) {
            SummaryEntry summaryEntry = new SummaryEntry(type.getFullName());
            Set<ConventionalCommit> commits = sortedMap.get(type);
            for (ConventionalCommit commit : commits) {
                summaryEntry.add(DefaultChangeLogEntryResolver.createListItem(commit));
                if (!commit.isBreakingChange()) continue;
                breakingChanges.add(DefaultChangeLogEntryResolver.createBreakingChangeListItem(commit));
            }
            releaseEntryBuilder.addChild(summaryEntry);
        }
        return breakingChanges.isEmpty() ? releaseEntryBuilder : releaseEntryBuilder.addChild(breakingChanges);
    }

    private static Map<CommitType, Set<ConventionalCommit>> groupByCommitType(List<ConventionalCommit> conventionalCommits) {
        Map groupByType = conventionalCommits.stream().collect(Collectors.groupingBy(ConventionalCommit::getType, Collectors.toSet()));
        TreeMap<CommitType, Set<ConventionalCommit>> sortedMap = new TreeMap<CommitType, Set<ConventionalCommit>>(Comparator.comparingInt(CommitType::getDisplayPriority));
        sortedMap.putAll(groupByType);
        return sortedMap;
    }

    private static ListItemEntry createListItem(ConventionalCommit commit) {
        return DefaultChangeLogEntryResolver.createListItemEntry(commit, commit.getScope(), commit.getMessage());
    }

    private static ListItemEntry createBreakingChangeListItem(ConventionalCommit commit) {
        return DefaultChangeLogEntryResolver.createListItemEntry(commit, commit.getScope(), commit.getBreakingChangeDescription());
    }

    private static ListItemEntry createListItemEntry(ConventionalCommit commit, String scope, String message) {
        return new ListItemEntry(!scope.isEmpty() ? commit.getDecoratedScope() + " " + message : message);
    }
}

