/*
 * Decompiled with CFR 0.152.
 */
package com.eugenenosenko.conventional.changelog.core;

import com.eugenenosenko.conventional.changelog.core.CommitBody;
import com.eugenenosenko.conventional.changelog.core.CommitFooter;
import com.eugenenosenko.conventional.changelog.core.CommitMessage;
import com.eugenenosenko.conventional.changelog.core.ConventionalCommit;
import com.eugenenosenko.conventional.changelog.core.ConventionalCommitResolver;
import com.eugenenosenko.conventional.changelog.util.ArrayUtil;
import com.eugenenosenko.conventional.changelog.util.CommitMatcherUtil;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jgit.revwalk.RevCommit;

public final class DefaultConventionalCommitResolver
implements ConventionalCommitResolver {
    @Override
    public List<ConventionalCommit> resolveConventionalCommits(Iterable<RevCommit> revCommits) {
        ArrayList<ConventionalCommit> conventionalCommits = new ArrayList<ConventionalCommit>();
        for (RevCommit revCommit : revCommits) {
            String[] commitMessageArray = revCommit.getFullMessage().split("\n\n");
            if (commitMessageArray.length < 1 || !ArrayUtil.first(commitMessageArray).trim().matches(CommitMatcherUtil.COMMIT_MESSAGE_REGEX.pattern())) continue;
            if (commitMessageArray.length == 1) {
                conventionalCommits.add(new ConventionalCommit(new CommitMessage(ArrayUtil.first(commitMessageArray))));
                continue;
            }
            if (commitMessageArray.length == 2) {
                conventionalCommits.add(new ConventionalCommit(new CommitMessage(ArrayUtil.first(commitMessageArray)), new CommitFooter(ArrayUtil.last(commitMessageArray))));
                continue;
            }
            conventionalCommits.add(new ConventionalCommit(new CommitMessage(ArrayUtil.first(commitMessageArray)), new CommitBody(ArrayUtil.drop(1, 1, commitMessageArray)), new CommitFooter(ArrayUtil.last(commitMessageArray))));
        }
        return conventionalCommits;
    }
}

