/*
 * Decompiled with CFR 0.152.
 */
package com.eugenenosenko.conventional.changelog.plugin;

import com.eugenenosenko.conventional.changelog.plugin.file.BackupLogHandler;
import com.eugenenosenko.conventional.changelog.plugin.file.ChangeLogHandler;
import com.eugenenosenko.conventional.changelog.plugin.file.LogFileHandler;
import com.eugenenosenko.conventional.changelog.plugin.git.DefaultGitService;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryBuilder;

abstract class AbstractChangeLogMojo
extends AbstractMojo {
    @Parameter(property="filename", defaultValue="CHANGELOG.md")
    protected String filename;
    @Parameter(property="backupFilename", defaultValue="CHANGELOG.md.backup")
    protected String backupFilename;
    @Parameter(defaultValue="${project.basedir}", required=true)
    protected File projectBaseDir;
    @Parameter(property="amendLastCommit", defaultValue="false")
    protected boolean amendLastCommit;
    @Parameter(property="release", defaultValue="-1")
    protected int release;

    AbstractChangeLogMojo() {
    }

    protected DefaultGitService createGitService() throws IOException {
        this.getLog().info((CharSequence)"Starting git service...");
        Repository repository = ((RepositoryBuilder)((RepositoryBuilder)new RepositoryBuilder().readEnvironment()).findGitDir(this.projectBaseDir)).build();
        this.getLog().info((CharSequence)("Resolved .git repository in " + this.projectBaseDir + " for branch " + repository.getFullBranch()));
        return new DefaultGitService(repository);
    }

    protected LogFileHandler createChangeLogFileHandler() {
        this.getLog().info((CharSequence)("Looking for " + this.filename + " file in project dir."));
        Path path = Paths.get(this.projectBaseDir.getAbsolutePath(), this.filename);
        return new ChangeLogHandler(path);
    }

    protected LogFileHandler createBackupLogFileHandler() {
        Path filePath = Paths.get(this.projectBaseDir.getAbsolutePath(), this.backupFilename);
        try {
            Files.deleteIfExists(filePath);
        }
        catch (IOException e) {
            this.getLog().warn((CharSequence)("Failed to delete backup file [" + this.backupFilename + "], will try to continue"));
        }
        return new BackupLogHandler(filePath);
    }
}

