/*
 * Decompiled with CFR 0.152.
 */
package com.eugenenosenko.conventional.changelog.plugin.context;

import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;

public final class VersionTag {
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private final String version;
    private final Date date;

    public VersionTag(RevCommit commit, String tagShortName) {
        this.date = new Date((long)commit.getCommitTime() * 1000L);
        this.version = tagShortName;
    }

    public static VersionTag resolve(Repository repository, Ref currentTag) throws IOException {
        RevCommit commit = repository.parseCommit((AnyObjectId)VersionTag.getObjectId(currentTag));
        return new VersionTag(commit, VersionTag.getTagShortName(currentTag));
    }

    private static ObjectId getObjectId(Ref reference) {
        if (reference.getPeeledObjectId() != null) {
            return reference.getPeeledObjectId();
        }
        return reference.getObjectId();
    }

    private static String getTagShortName(Ref tagRef) {
        return tagRef.getName().replace("refs/tags/", "").replace("v", "");
    }

    public String toString() {
        return "VersionTag{version='" + this.version + '\'' + ", date=" + this.date + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VersionTag that = (VersionTag)o;
        return Objects.equals(this.version, that.version) && Objects.equals(this.date, that.date);
    }

    public int hashCode() {
        return Objects.hash(this.version, this.date);
    }

    public String getVersion() {
        return this.version;
    }

    public Date getDate() {
        return this.date;
    }

    public String getDecoratedVersionTag() {
        return this.version + " (" + DATE_FORMAT.format(this.date) + ")";
    }
}

