/*
 * Decompiled with CFR 0.152.
 */
package com.eugenenosenko.conventional.changelog.plugin.git;

import com.eugenenosenko.conventional.changelog.plugin.context.VersionTag;
import com.eugenenosenko.conventional.changelog.plugin.exception.TagListSortingException;
import com.eugenenosenko.conventional.changelog.plugin.git.GitService;
import com.eugenenosenko.conventional.changelog.util.GitUtil;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;
import org.eclipse.jgit.api.CommitCommand;
import org.eclipse.jgit.api.DeleteTagCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.LogCommand;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.api.TagCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revplot.PlotWalk;
import org.eclipse.jgit.revwalk.RevCommit;

public final class DefaultGitService
implements AutoCloseable,
GitService {
    private final Repository repository;
    private final Git git;

    public DefaultGitService(Repository repository) {
        this.repository = repository;
        this.git = new Git(repository);
    }

    @Override
    public List<Ref> getTagList() throws GitAPIException {
        List unsortedTagList = this.git.tagList().call();
        return this.sortTagListByDate(unsortedTagList);
    }

    private List<Ref> sortTagListByDate(List<Ref> unsortedTagList) {
        unsortedTagList.sort(Comparator.comparing(DefaultGitService.tagSortingFunction(this.repository)));
        return unsortedTagList;
    }

    @Override
    public RevCommit getCommitForRef(Ref ref) throws IOException {
        return this.repository.parseCommit((AnyObjectId)GitUtil.getObjectId(ref));
    }

    private static Function<Ref, Integer> tagSortingFunction(Repository repository) {
        return ref -> {
            try {
                return repository.parseCommit((AnyObjectId)GitUtil.getObjectId(ref)).getCommitTime();
            }
            catch (IOException e) {
                throw new TagListSortingException("Failed to sort tag list. Exception occurred when tried to parse commit from tag ref", e);
            }
        };
    }

    private List<RevCommit> fetchCommitsWithRange(ObjectId startId, ObjectId endId) throws IOException {
        RevCommit revCommit;
        LinkedList<RevCommit> commitsInRange = new LinkedList<RevCommit>();
        PlotWalk walk = new PlotWalk(this.repository);
        RevCommit start = walk.parseCommit((AnyObjectId)startId);
        RevCommit end = endId != null ? walk.parseCommit((AnyObjectId)endId) : null;
        walk.markStart(start);
        while (!((revCommit = walk.next()) == null || end != null && revCommit.getId().equals((AnyObjectId)end.getId()))) {
            commitsInRange.addLast(revCommit);
        }
        commitsInRange.removeFirst();
        walk.close();
        return commitsInRange;
    }

    @Override
    public Map<VersionTag, List<RevCommit>> fetchCommitsFromVersion(String since) throws GitAPIException, IOException {
        List<Ref> tagList = this.getTagList();
        if (!this.isTheLastTag(since)) {
            for (int i = 0; i < tagList.size(); ++i) {
                if (!tagList.get(i).getName().contains(since)) continue;
                List<Ref> refs = tagList.subList(i, tagList.size());
                return this.fetchCommitsForTags(refs, false);
            }
        }
        return Collections.emptyMap();
    }

    private boolean isTheLastTag(String sinceVersion) throws GitAPIException {
        List<Ref> tagList = this.getTagList();
        if (tagList.size() > 0) {
            return tagList.get(tagList.size() - 1).getName().contains(sinceVersion);
        }
        return false;
    }

    @Override
    public Map<VersionTag, List<RevCommit>> fetchCommitsForTags(List<Ref> tagList, boolean includeFirstTag) throws IOException {
        TreeMap<VersionTag, List<RevCommit>> tagMap = new TreeMap<VersionTag, List<RevCommit>>(Comparator.comparing(VersionTag::getDate));
        LinkedList<Ref> queue = new LinkedList<Ref>(tagList);
        if (includeFirstTag) {
            queue.addFirst(null);
        }
        Ref fromTag = queue.pollLast();
        while (!queue.isEmpty()) {
            Ref untilTag = queue.pollLast();
            ObjectId fromTagId = GitUtil.getObjectId(fromTag);
            ObjectId untilTagId = untilTag != null ? GitUtil.getObjectId(untilTag) : null;
            List<RevCommit> revCommits = this.fetchCommitsWithRange(fromTagId, untilTagId);
            tagMap.put(VersionTag.resolve(this.repository, fromTag), revCommits);
            fromTag = untilTag;
        }
        return tagMap;
    }

    @Override
    public void addFile(String filenamePattern) throws GitAPIException {
        this.git.add().addFilepattern(filenamePattern).call();
    }

    @Override
    public Ref getLastTag() throws GitAPIException {
        List tagList = this.git.tagList().call();
        return (Ref)tagList.get(this.getTagList().size() - 1);
    }

    @Override
    public RevCommit getLastCommit() throws GitAPIException {
        LogCommand log = this.git.log();
        log.setMaxCount(1);
        Iterable call = log.call();
        return (RevCommit)call.iterator().next();
    }

    @Override
    public void commitWithMessage(String message) throws GitAPIException {
        CommitCommand commit = this.git.commit();
        commit.setMessage(message);
        commit.call();
    }

    @Override
    public void applyTag(String tag) throws GitAPIException {
        TagCommand tagCommand = this.git.tag();
        tagCommand.setName(tag);
        tagCommand.call();
    }

    @Override
    public void deleteTag(String tag) throws GitAPIException {
        DeleteTagCommand deleteTagCommand = this.git.tagDelete();
        deleteTagCommand.setTags(new String[]{tag});
        deleteTagCommand.call();
    }

    @Override
    public void softResetToRef(String ref) throws GitAPIException {
        ResetCommand resetCommand = this.git.reset();
        resetCommand.setRef(ref);
        resetCommand.setMode(ResetCommand.ResetType.SOFT);
        resetCommand.call();
    }

    @Override
    public void close() {
        this.git.close();
    }
}

