/*
 * Decompiled with CFR 0.152.
 */
package com.eugenenosenko.conventional.changelog.plugin.git;

import com.eugenenosenko.conventional.changelog.plugin.backup.Undoable;
import com.eugenenosenko.conventional.changelog.plugin.git.GitService;
import com.eugenenosenko.conventional.changelog.util.GitUtil;
import java.io.IOException;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.revwalk.RevCommit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GitVersionManager
implements Undoable {
    private static final Logger log = LoggerFactory.getLogger(GitVersionManager.class);
    private final GitService gitService;

    public GitVersionManager(GitService gitService) {
        this.gitService = gitService;
    }

    public void amendLastCommitAndAddChangelog(String changelogFile) throws GitAPIException, IOException {
        boolean shouldAmendTag = false;
        Ref lastTagRef = this.gitService.getLastTag();
        String lastTagName = GitUtil.getTagShortName(lastTagRef);
        RevCommit lastCommit = this.gitService.getLastCommit();
        if (this.gitService.getCommitForRef(lastTagRef).equals((AnyObjectId)lastCommit)) {
            log.info("Deleting previous tag {}", (Object)lastTagName);
            this.gitService.deleteTag(lastTagName);
            shouldAmendTag = true;
        }
        log.info("Amending last commit...");
        this.gitService.softResetToRef("HEAD~1");
        this.gitService.addFile(changelogFile);
        log.info("Staged changelog file {} ", (Object)changelogFile);
        this.gitService.commitWithMessage(lastCommit.getFullMessage());
        log.info("Reapplied last commit");
        if (shouldAmendTag) {
            this.gitService.applyTag(lastTagName);
            log.info("Reapplied last tag");
        }
    }

    @Override
    public void undo() {
        throw new UnsupportedOperationException("Undo operation is not supported yet");
    }
}

