/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.AcknowledgedBulkWriteResult;
import com.mongodb.BulkWriteResult;
import com.mongodb.BulkWriteUpsert;
import com.mongodb.InsertManyWriteConcernException;
import com.mongodb.UnacknowledgedBulkWriteResult;
import com.mongodb.WriteConcern;
import com.mongodb.WriteConcernException;
import com.mongodb.WriteResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import org.bson.BsonDocument;

public class FongoBulkWriteCombiner {
    private final WriteConcern writeConcern;
    private int insertedCount = 0;
    private int matchedCount = 0;
    private int removedCount = 0;
    private int modifiedCount = 0;
    private final Set<BulkWriteUpsert> upserts = new TreeSet<BulkWriteUpsert>(new Comparator<BulkWriteUpsert>(){

        @Override
        public int compare(BulkWriteUpsert o1, BulkWriteUpsert o2) {
            return o1.getIndex() < o2.getIndex() ? -1 : (o1.getIndex() == o2.getIndex() ? 0 : 1);
        }
    });
    private final TreeSet<WriteError> errors = new TreeSet<WriteError>(new Comparator<WriteError>(){

        @Override
        public int compare(WriteError o1, WriteError o2) {
            return o1.getIndex() < o2.getIndex() ? -1 : (o1.getIndex() == o2.getIndex() ? 0 : 1);
        }
    });

    public FongoBulkWriteCombiner(WriteConcern writeConcern) {
        this.writeConcern = writeConcern;
    }

    public void addReplaceResult(int idx, WriteResult wr) {
        this.addUpdateResult(idx, wr);
    }

    public void addUpdateResult(int idx, WriteResult wr) {
        if (wr.isUpdateOfExisting()) {
            this.matchedCount += wr.getN();
            this.modifiedCount += wr.getN();
        } else if (wr.getUpsertedId() != null) {
            this.upserts.add(new BulkWriteUpsert(idx, wr.getUpsertedId()));
        }
    }

    public void addRemoveResult(WriteResult wr) {
        this.matchedCount += wr.getN();
        this.removedCount += wr.getN();
    }

    public void addInsertResult(WriteResult wr) {
        this.insertedCount += wr.getN();
    }

    public void addInsertError(int idx, WriteConcernException exception) {
        this.errors.add(new WriteError(idx, exception));
    }

    public BulkWriteResult getBulkWriteResult(WriteConcern writeConcern) {
        if (!writeConcern.isAcknowledged()) {
            return new UnacknowledgedBulkWriteResult();
        }
        return new AcknowledgedBulkWriteResult(this.insertedCount, this.matchedCount, this.removedCount, Integer.valueOf(this.modifiedCount), new ArrayList<BulkWriteUpsert>(this.upserts));
    }

    public void throwOnError() {
        if (!this.errors.isEmpty()) {
            BulkWriteResult bulkWriteResult = this.getBulkWriteResult(this.writeConcern);
            throw new InsertManyWriteConcernException(bulkWriteResult, Collections.unmodifiableList(new ArrayList<WriteError>(this.errors)));
        }
    }

    public static class WriteError {
        private final int index;
        private final int code;
        private final String message;
        private final BsonDocument details;
        private final WriteConcernException exception;

        public WriteError(int index, WriteConcernException exception) {
            this.index = index;
            this.exception = exception;
            this.code = exception.getErrorCode();
            this.message = exception.getErrorMessage();
            this.details = exception.getResponse();
        }

        public int getIndex() {
            return this.index;
        }

        public int getCode() {
            return this.code;
        }

        public String getMessage() {
            return this.message;
        }

        public BsonDocument getDetails() {
            return this.details;
        }

        public WriteConcernException getException() {
            return this.exception;
        }
    }
}

