/*
 * Decompiled with CFR 0.152.
 */
package com.github.ferstl.depgraph.dependency;

import com.github.ferstl.depgraph.dependency.DependencyNode;
import com.github.ferstl.depgraph.dependency.DependencyNodeIdRenderer;
import com.github.ferstl.depgraph.dependency.GraphFactory;
import com.github.ferstl.depgraph.graph.GraphBuilder;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.maven.execution.ProjectDependencyGraph;
import org.apache.maven.project.MavenProject;

public class ReactorGraphFactory
implements GraphFactory {
    private final ProjectDependencyGraph projectDependencyGraph;
    private final GraphBuilder<DependencyNode> graphBuilder;
    private final DependencyNodeIdRenderer nodeIdRenderer;

    public ReactorGraphFactory(ProjectDependencyGraph projectDependencyGraph, GraphBuilder<DependencyNode> graphBuilder, DependencyNodeIdRenderer nodeIdRenderer) {
        this.projectDependencyGraph = projectDependencyGraph;
        this.graphBuilder = graphBuilder;
        this.nodeIdRenderer = nodeIdRenderer;
    }

    @Override
    public String createGraph(MavenProject project) {
        List sortedProjects = this.projectDependencyGraph.getSortedProjects();
        Collections.reverse(sortedProjects);
        HashSet<String> processedProjects = new HashSet<String>();
        for (MavenProject parentProject : sortedProjects) {
            DependencyNode parentNode = new DependencyNode(parentProject.getArtifact());
            for (MavenProject downstreamProject : this.projectDependencyGraph.getDownstreamProjects(parentProject, false)) {
                DependencyNode childNode = new DependencyNode(downstreamProject.getArtifact());
                String nodeString = this.nodeIdRenderer.render(childNode);
                if (!processedProjects.contains(nodeString)) {
                    this.graphBuilder.addEdge(parentNode, childNode);
                }
                processedProjects.add(nodeString);
            }
        }
        return this.graphBuilder.toString();
    }
}

