/*
 * Copyright (c) 2013, Randy Watler <watler@wispertel.net>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the Lesser GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * Lesser GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.github.fge.jsonpatch.diff;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.fge.jackson.JacksonUtils;
import com.github.fge.jackson.jsonpointer.JsonPointer;

/**
 * Difference operation types. Add, remove, and replace operations
 * are directly generated by node comparison. Move operations are
 * the result of factorized add and remove operations.
 */
enum DiffOperation
{
    ADD("add"),
    REMOVE("remove"),
    REPLACE("replace"),
    MOVE("move"),
    COPY("copy"),
    ;

    private final String opName;

    DiffOperation(final String opName)
    {
        this.opName = opName;
    }

    ObjectNode newOp(final JsonPointer ptr)
    {
        final ObjectNode ret = JacksonUtils.nodeFactory().objectNode();
        ret.put("op", opName);
        ret.put("path", ptr.toString());
        return ret;
    }

    @Override
    public String toString()
    {
        return opName;
    }
}
